﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/rds/RDS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace RDS {
namespace Model {

/**
 * <p>A response element in the <code>ModifyTenantDatabase</code> operation that
 * describes changes that will be applied. Specific changes are identified by
 * subelements.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/TenantDatabasePendingModifiedValues">AWS
 * API Reference</a></p>
 */
class TenantDatabasePendingModifiedValues {
 public:
  AWS_RDS_API TenantDatabasePendingModifiedValues() = default;
  AWS_RDS_API TenantDatabasePendingModifiedValues(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_RDS_API TenantDatabasePendingModifiedValues& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_RDS_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_RDS_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The master password for the tenant database.</p>
   */
  inline const Aws::String& GetMasterUserPassword() const { return m_masterUserPassword; }
  inline bool MasterUserPasswordHasBeenSet() const { return m_masterUserPasswordHasBeenSet; }
  template <typename MasterUserPasswordT = Aws::String>
  void SetMasterUserPassword(MasterUserPasswordT&& value) {
    m_masterUserPasswordHasBeenSet = true;
    m_masterUserPassword = std::forward<MasterUserPasswordT>(value);
  }
  template <typename MasterUserPasswordT = Aws::String>
  TenantDatabasePendingModifiedValues& WithMasterUserPassword(MasterUserPasswordT&& value) {
    SetMasterUserPassword(std::forward<MasterUserPasswordT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the tenant database.</p>
   */
  inline const Aws::String& GetTenantDBName() const { return m_tenantDBName; }
  inline bool TenantDBNameHasBeenSet() const { return m_tenantDBNameHasBeenSet; }
  template <typename TenantDBNameT = Aws::String>
  void SetTenantDBName(TenantDBNameT&& value) {
    m_tenantDBNameHasBeenSet = true;
    m_tenantDBName = std::forward<TenantDBNameT>(value);
  }
  template <typename TenantDBNameT = Aws::String>
  TenantDatabasePendingModifiedValues& WithTenantDBName(TenantDBNameT&& value) {
    SetTenantDBName(std::forward<TenantDBNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_masterUserPassword;
  bool m_masterUserPasswordHasBeenSet = false;

  Aws::String m_tenantDBName;
  bool m_tenantDBNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace RDS
}  // namespace Aws
