/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.LinkedList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataTypeAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSContextBoundAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreDataBoundTypeAttribute<CONTAINER extends DBSEntity & PostgreObject>
extends PostgreAttribute<CONTAINER>
implements DBSEntityAttribute,
DBSAttributeEnumerable,
DBSContextBoundAttribute {
    private final DBDAttributeBinding context;
    private final PostgreDataTypeAttribute member;

    public PostgreDataBoundTypeAttribute(@NotNull DBRProgressMonitor monitor, @NotNull CONTAINER container, @Nullable DBDAttributeBinding context, @NotNull PostgreDataTypeAttribute attr) throws DBException {
        super(monitor, container, attr);
        this.context = context;
        this.member = attr;
    }

    @NotNull
    public String formatMemberReference(boolean isIncludeContainerName, @Nullable String containerAliasOrNull, @NotNull DBPAttributeReferencePurpose purpose) {
        LinkedList<String> parts = new LinkedList<String>();
        parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)this.member));
        DBDAttributeBinding bindingContext = this.context;
        DBSEntityAttribute entityContext = bindingContext.getEntityAttribute();
        while (entityContext instanceof PostgreDataBoundTypeAttribute) {
            PostgreDataBoundTypeAttribute boundAttr = (PostgreDataBoundTypeAttribute)entityContext;
            parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)boundAttr.member));
            bindingContext = boundAttr.context;
            entityContext = bindingContext.getEntityAttribute();
        }
        if (entityContext != null) {
            parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)entityContext));
            if (isIncludeContainerName) {
                if (containerAliasOrNull == null) {
                    if (entityContext.getParentObject() != this.getTable()) {
                        parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)entityContext.getParentObject()));
                    }
                    parts.addFirst(DBUtils.getObjectFullName((DBPNamedObject)this.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DML));
                } else {
                    parts.addFirst(containerAliasOrNull);
                }
            }
        } else if (isIncludeContainerName) {
            parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)bindingContext));
            if (containerAliasOrNull != null) {
                parts.addFirst(containerAliasOrNull);
            }
        }
        if (purpose.equals((Object)DBPAttributeReferencePurpose.DATA_SELECTION)) {
            return "(".repeat(parts.size() - 1) + String.join((CharSequence)").", parts);
        }
        return String.join((CharSequence)".", parts);
    }

    @Override
    @NotNull
    public PostgreSchema getSchema() {
        return this.member.getSchema();
    }
}

