/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.sourcemap;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.sourcemap.SourceMapAdapterV0;
import ghidra.program.model.address.Address;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class SourceMapAdapter {
    static final String TABLE_NAME = "SourceMap";
    static final int FILE_LINE_COL = 0;
    static final int BASE_ADDR_COL = 1;
    static final int LENGTH_COL = 2;

    SourceMapAdapter() {
    }

    static SourceMapAdapter getAdapter(DBHandle dbh, AddressMapDB addrMap, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        return new SourceMapAdapterV0(dbh, addrMap, openMode);
    }

    abstract boolean removeRecord(long var1) throws IOException;

    abstract RecordIterator getSourceMapRecordIterator(Address var1, boolean var2) throws IOException;

    abstract RecordIterator getRecordsForSourceFile(long var1, int var3, int var4) throws IOException;

    abstract DBRecord addMapEntry(long var1, int var3, Address var4, long var5) throws IOException;

    abstract void moveAddressRange(Address var1, Address var2, long var3, TaskMonitor var5) throws CancelledException, IOException;
}

