/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.udif;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.catacombae.dmgextractor.DmgException;
import org.catacombae.dmgextractor.Util;
import org.catacombae.dmgextractor.io.RandomAccessInputStream;
import org.catacombae.dmgextractor.io.SynchronizedRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.udif.UDIFBlock;

public abstract class UDIFBlockInputStream
extends InputStream {
    protected ReadableRandomAccessStream raf;
    protected UDIFBlock block;
    protected final int addInOffset;
    private long globalBytesRead;
    protected final byte[] buffer = new byte[16384];
    protected int bufferPos = 0;
    protected int bufferDataLength = 0;
    private final byte[] skipBuffer = new byte[4096];
    protected int fillSize;

    protected UDIFBlockInputStream(ReadableRandomAccessStream raf, UDIFBlock block, int addInOffset) {
        this.raf = raf;
        this.block = block;
        this.addInOffset = addInOffset;
    }

    public static UDIFBlockInputStream getStream(ReadableRandomAccessStream raf, UDIFBlock block) throws IOException, RuntimeIOException {
        switch (block.getBlockType()) {
            case -2147483643: {
                return new ZlibBlockInputStream(raf, block, 0);
            }
            case -2147483642: {
                return new Bzip2BlockInputStream(raf, block, 0);
            }
            case 1: {
                return new CopyBlockInputStream(raf, block, 0);
            }
            case 0: 
            case 2: {
                return new ZeroBlockInputStream(raf, block, 0);
            }
            case -1: 
            case 0x7FFFFFFE: {
                throw new RuntimeException("Block type is a marker and contains no data.");
            }
        }
        throw new RuntimeException("No handler for block type " + block.getBlockTypeAsString());
    }

    public int available() throws IOException {
        long available = this.block.getOutSize() - this.globalBytesRead;
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)available;
    }

    public void close() throws IOException {
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b, 0, 1);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        int bytesToReadFromBuffer;
        int bytesToRead = len;
        int outPos = off;
        for (bytesRead = 0; bytesRead < bytesToRead; bytesRead += bytesToReadFromBuffer) {
            int bytesRemainingInBuffer = this.bufferDataLength - this.bufferPos;
            if (bytesRemainingInBuffer == 0) {
                this.fillBuffer();
                bytesRemainingInBuffer = this.bufferDataLength - this.bufferPos;
                if (bytesRemainingInBuffer == 0) {
                    if (bytesRead != 0) break;
                    return -1;
                }
            }
            bytesToReadFromBuffer = bytesToRead - bytesRead < bytesRemainingInBuffer ? bytesToRead - bytesRead : bytesRemainingInBuffer;
            System.arraycopy(this.buffer, this.bufferPos, b, outPos, bytesToReadFromBuffer);
            outPos += bytesToReadFromBuffer;
            this.bufferPos += bytesToReadFromBuffer;
        }
        this.globalBytesRead += (long)bytesRead;
        return bytesRead;
    }

    public void reset() throws IOException {
    }

    public long skip(long n) throws IOException {
        int curSkip;
        long bytesSkipped;
        int res;
        for (bytesSkipped = 0L; bytesSkipped < n && (res = this.read(this.skipBuffer, 0, curSkip = n - bytesSkipped < (long)this.skipBuffer.length ? (int)(n - bytesSkipped) : this.skipBuffer.length)) > 0; bytesSkipped += (long)res) {
        }
        return bytesSkipped;
    }

    protected abstract void fillBuffer() throws IOException;

    public static class Bzip2BlockInputStream
    extends UDIFBlockInputStream {
        private final byte[] BZIP2_SIGNATURE = new byte[]{66, 90};
        private InputStream bzip2DataStream;
        private CBZip2InputStream decompressingStream;
        private long outPos = 0L;

        public Bzip2BlockInputStream(ReadableRandomAccessStream raf, UDIFBlock block, int addInOffset) throws IOException, RuntimeIOException {
            super(raf, block, addInOffset);
            this.bzip2DataStream = new RandomAccessInputStream(new SynchronizedRandomAccessStream(raf), block.getTrueInOffset(), block.getInSize());
            byte[] signature = new byte[2];
            if (this.bzip2DataStream.read(signature) != signature.length) {
                throw new RuntimeException("Read error!");
            }
            if (!Util.arraysEqual(signature, this.BZIP2_SIGNATURE)) {
                throw new RuntimeException("Invalid bzip2 block!");
            }
            this.decompressingStream = new CBZip2InputStream((InputStream)new BufferedInputStream(this.bzip2DataStream));
        }

        protected void fillBuffer() throws IOException {
            int bytesRead;
            int bytesToRead = (int)Math.min(this.block.getOutSize() - this.outPos, (long)this.buffer.length);
            int totalBytesRead = 0;
            while (totalBytesRead < bytesToRead && (bytesRead = this.decompressingStream.read(this.buffer, totalBytesRead, bytesToRead - totalBytesRead)) >= 0) {
                totalBytesRead += bytesRead;
                this.outPos += (long)bytesRead;
            }
            this.bufferPos = 0;
            this.bufferDataLength = totalBytesRead;
        }

        public void close() throws IOException {
            this.decompressingStream.close();
            this.bzip2DataStream.close();
        }
    }

    public static class ZeroBlockInputStream
    extends UDIFBlockInputStream {
        private long outPos = 0L;

        public ZeroBlockInputStream(ReadableRandomAccessStream raf, UDIFBlock block, int addInOffset) throws RuntimeIOException {
            super(raf, block, addInOffset);
        }

        protected void fillBuffer() throws IOException {
            int bytesToWrite = (int)Math.min(this.block.getOutSize() - this.outPos, (long)this.buffer.length);
            Util.zero(this.buffer, 0, bytesToWrite);
            this.outPos += (long)bytesToWrite;
            this.bufferPos = 0;
            this.bufferDataLength = bytesToWrite;
        }

        public long skip(long n) throws IOException {
            int bytesToSkip = (int)Math.min(this.block.getOutSize() - this.outPos, n);
            this.outPos += (long)bytesToSkip;
            this.bufferPos = 0;
            this.bufferDataLength = 0;
            return bytesToSkip;
        }
    }

    public static class CopyBlockInputStream
    extends UDIFBlockInputStream {
        private long inPos = 0L;

        public CopyBlockInputStream(ReadableRandomAccessStream raf, UDIFBlock block, int addInOffset) throws RuntimeIOException {
            super(raf, block, addInOffset);
        }

        protected void fillBuffer() throws IOException {
            int bytesRead;
            this.raf.seek((long)this.addInOffset + this.inPos + this.block.getTrueInOffset());
            int bytesToRead = (int)Math.min(this.block.getInSize() - this.inPos, (long)this.buffer.length);
            int totalBytesRead = 0;
            while (totalBytesRead < bytesToRead && (bytesRead = this.raf.read(this.buffer, totalBytesRead, bytesToRead - totalBytesRead)) >= 0) {
                totalBytesRead += bytesRead;
                this.inPos += (long)bytesRead;
            }
            this.bufferPos = 0;
            this.bufferDataLength = totalBytesRead;
        }

        public long skip(long n) throws IOException {
            int bytesToSkip = (int)Math.min(this.block.getInSize() - this.inPos, n);
            this.inPos += (long)bytesToSkip;
            this.bufferPos = 0;
            this.bufferDataLength = 0;
            return bytesToSkip;
        }
    }

    public static class ZlibBlockInputStream
    extends UDIFBlockInputStream {
        private final Inflater inflater = new Inflater();
        private final byte[] inBuffer = new byte[4096];
        private long inPos = 0L;

        public ZlibBlockInputStream(ReadableRandomAccessStream raf, UDIFBlock block, int addInOffset) throws IOException {
            super(raf, block, addInOffset);
            this.feedInflater();
        }

        private void feedInflater() throws IOException {
            long seekPos = (long)this.addInOffset + this.inPos + this.block.getTrueInOffset();
            this.raf.seek(seekPos);
            long bytesLeftToRead = this.block.getInSize() - this.inPos;
            int bytesToFeed = (long)this.inBuffer.length < bytesLeftToRead ? this.inBuffer.length : (int)bytesLeftToRead;
            int curBytesRead = this.raf.read(this.inBuffer, 0, bytesToFeed);
            this.inPos += (long)curBytesRead;
            this.inflater.setInput(this.inBuffer, 0, curBytesRead);
        }

        protected void fillBuffer() throws RuntimeIOException, IOException {
            if (this.inflater.finished()) {
                this.bufferPos = 0;
                this.bufferDataLength = 0;
            }
            try {
                int bytesInflated;
                int res;
                for (bytesInflated = 0; bytesInflated < this.buffer.length && !this.inflater.finished(); bytesInflated += res) {
                    if (this.inflater.needsInput()) {
                        this.feedInflater();
                    }
                    if ((res = this.inflater.inflate(this.buffer, bytesInflated, this.buffer.length - bytesInflated)) >= 0) {
                        continue;
                    }
                    throw new DmgException("Negative return value when inflating");
                }
                this.bufferPos = 0;
                this.bufferDataLength = bytesInflated;
            }
            catch (DataFormatException e) {
                DmgException re = new DmgException("Invalid zlib data!");
                re.initCause(e);
                throw re;
            }
        }
    }
}

