/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.dbtable;

import db.BinaryField;
import db.BooleanField;
import db.ByteField;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import db.StringField;
import db.Table;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.app.plugin.debug.dbtable.AbstractColumnAdapter;
import ghidra.app.plugin.debug.dbtable.BinaryColumnAdapter;
import ghidra.app.plugin.debug.dbtable.BooleanColumnAdapter;
import ghidra.app.plugin.debug.dbtable.ByteColumnAdapter;
import ghidra.app.plugin.debug.dbtable.IntegerColumnAdapter;
import ghidra.app.plugin.debug.dbtable.LongColumnAdapter;
import ghidra.app.plugin.debug.dbtable.ShortColumnAdapter;
import ghidra.app.plugin.debug.dbtable.StringColumnAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DbSmallTableModel
extends ThreadedTableModel<DBRecord, Object> {
    private Table table;
    private Schema schema;

    public DbSmallTableModel(ServiceProvider serviceProvider, Table table) {
        super("DB Records Model", serviceProvider);
        this.table = table;
        this.schema = table.getSchema();
        this.reloadColumns();
    }

    protected void doLoad(Accumulator<DBRecord> accumulator, TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.table.getRecordCount());
        try {
            RecordIterator it = this.table.iterator();
            while (it.hasNext()) {
                monitor.checkCancelled();
                accumulator.add((Object)it.next());
            }
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private AbstractColumnAdapter getColumn(Field field, int column) {
        String columnName = this.loadColumnName(column);
        if (field instanceof ByteField) {
            return new ByteColumnAdapter(columnName, column);
        }
        if (field instanceof BooleanField) {
            return new BooleanColumnAdapter(columnName, column);
        }
        if (field instanceof ShortField) {
            return new ShortColumnAdapter(columnName, column);
        }
        if (field instanceof IntField) {
            return new IntegerColumnAdapter(columnName, column);
        }
        if (field instanceof LongField) {
            return new LongColumnAdapter(columnName, column);
        }
        if (field instanceof StringField) {
            return new StringColumnAdapter(columnName, column);
        }
        if (field instanceof BinaryField) {
            return new BinaryColumnAdapter(columnName, column);
        }
        throw new AssertException("New, unexpected DB column type: " + field.getClass().getSimpleName());
    }

    private String loadColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return this.schema.getKeyName();
        }
        --columnIndex;
        int[] indexCols = this.table.getIndexedColumns();
        boolean isIndexed = false;
        for (int indexCol : indexCols) {
            if (indexCol != columnIndex) continue;
            isIndexed = true;
            break;
        }
        return this.schema.getFieldNames()[columnIndex] + (isIndexed ? "*" : "");
    }

    protected TableColumnDescriptor<DBRecord> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        if (this.schema == null) {
            return descriptor;
        }
        descriptor.addVisibleColumn((DynamicTableColumn)this.getColumn(this.schema.getKeyFieldType(), 0));
        Field[] fields = this.schema.getFields();
        int offset = 1;
        for (Field field : fields) {
            descriptor.addVisibleColumn((DynamicTableColumn)this.getColumn(field, offset++));
        }
        return descriptor;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getDataSource() {
        return null;
    }
}

