/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.List;

public class Annotation {
    public static final String ESCAPABLE_CHARS = "{}\"\\";
    private String annotationText;
    private String[] annotationParts;

    public Annotation(String annotationText, Program program) {
        this.annotationText = annotationText;
        this.annotationParts = this.parseAnnotationText(annotationText);
    }

    public String[] getAnnotationParts() {
        return this.annotationParts;
    }

    public String getAnnotationText() {
        return this.annotationText;
    }

    public String toString() {
        return this.annotationText;
    }

    private String[] parseAnnotationText(String text) {
        String trimmed = text.substring(2, text.length() - 1);
        ArrayList<String> tokens = new ArrayList<String>();
        List<TextPart> parts = this.parseText(trimmed);
        for (TextPart part : parts) {
            part.grabTokens(tokens);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private List<TextPart> parseText(String text) {
        ArrayList<TextPart> textParts = new ArrayList<TextPart>();
        boolean escaped = false;
        boolean inQuote = false;
        int partStart = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            boolean wasEscaped = escaped;
            escaped = false;
            int prev = 0;
            if (i != 0 && !wasEscaped) {
                prev = text.charAt(i - 1);
            }
            char c = text.charAt(i);
            if (prev == 92 && ESCAPABLE_CHARS.indexOf(c) != -1) {
                escaped = true;
                continue;
            }
            if (c != '\"') continue;
            if (inQuote) {
                s = text.substring(partStart, i + 1);
                textParts.add(new QuotedTextPart(this, s));
                partStart = i + 1;
            } else if (i != 0) {
                s = text.substring(partStart, i);
                textParts.add(new TextPart(this, s));
                partStart = i;
            }
            inQuote = !inQuote;
        }
        if (partStart < n) {
            String s = text.substring(partStart, n);
            textParts.add(new TextPart(this, s));
        }
        return textParts;
    }

    private static String removeEscapeChars(String text) {
        boolean escaped = false;
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean wasEscaped = escaped;
            escaped = false;
            if (c != '\\') {
                buffy.append(c);
                continue;
            }
            int next = 0;
            if (i != text.length() - 1 && !wasEscaped) {
                next = text.charAt(i + 1);
            }
            if (ESCAPABLE_CHARS.indexOf(next) != -1) {
                escaped = true;
                continue;
            }
            buffy.append(c);
        }
        return buffy.toString();
    }

    private class TextPart {
        protected String text;

        TextPart(Annotation annotation, String text) {
            this.text = text;
        }

        public void grabTokens(List<String> tokens) {
            String[] strings;
            String escaped = Annotation.removeEscapeChars(this.text);
            for (String string : strings = escaped.split("\\s")) {
                if (string.length() <= 0) continue;
                tokens.add(string);
            }
        }

        public String toString() {
            return this.text;
        }
    }

    private class QuotedTextPart
    extends TextPart {
        QuotedTextPart(Annotation annotation, String text) {
            super(annotation, text);
        }

        @Override
        public void grabTokens(List<String> tokens) {
            String unquoted = this.text.substring(1, this.text.length() - 1);
            String escaped = Annotation.removeEscapeChars(unquoted);
            tokens.add(escaped);
        }
    }
}

