/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.FilterAtom;
import java.sql.SQLException;

public class Md5BSimFilterType
extends BSimFilterType {
    public static final String XML_VALUE = "md5equals";
    public static final String md5Regex = "[a-fA-F0-9]{32}";

    public Md5BSimFilterType() {
        super("MD5 equals", XML_VALUE, "32-digit hex value");
    }

    @Override
    public void gatherSQLEffect(SQLEffects effect, FilterAtom atom, IDSQLResolution res) throws SQLException {
        StringBuilder buf = new StringBuilder();
        effect.setExeTable();
        buf.append("exetable.md5 = '").append(atom.value).append('\'');
        effect.addWhere(this, buf.toString());
    }

    @Override
    public void gatherElasticEffect(ElasticEffects effect, FilterAtom atom, IDElasticResolution resolution) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"filter\": { \"term\": { \"md5\": \"");
        buffer.append(atom.value);
        buffer.append("\" } } ");
        effect.addStandalone(this, buffer.toString());
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        return value.equals(rec.getMd5());
    }

    @Override
    public String normalizeValue(String value) {
        if ((value = value.trim()).length() == 34 && value.charAt(0) == '0' && value.charAt(1) == 'x') {
            value = value.substring(2, 34);
        }
        if (value.length() != 32 || !value.matches(md5Regex)) {
            return null;
        }
        value = value.toLowerCase();
        return value;
    }

    @Override
    public boolean isValidValue(String value) {
        if ((value = value.trim()).length() == 34 && value.charAt(0) == '0' && value.charAt(1) == 'x') {
            value = value.substring(2, 34);
        }
        return value.length() == 32 && value.matches(md5Regex);
    }

    @Override
    public IDSQLResolution generateIDSQLResolution(FilterAtom atom) {
        return null;
    }
}

