/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.GhidraColorChooser;
import ghidra.util.Swing;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.event.ChangeListener;

public class ColorPropertyEditor
extends PropertyEditorSupport {
    private GhidraColorChooser colorChooser;
    private ChangeListener listener = e -> this.colorChanged();

    private void colorChanged() {
        Swing.runLater(() -> this.setValue(this.colorChooser.getColor()));
    }

    @Override
    public Component getCustomEditor() {
        ArrayList<Color> recent = new ArrayList<Color>();
        ArrayList<Color> history = new ArrayList<Color>();
        String activeTab = null;
        if (this.colorChooser != null) {
            history.addAll(this.colorChooser.getColorHistory());
            recent.addAll(this.colorChooser.getRecentColors());
            activeTab = this.colorChooser.getActiveTab();
            this.colorChooser.getSelectionModel().removeChangeListener(this.listener);
        }
        this.colorChooser = new GhidraColorChooser();
        this.colorChooser.setColorHistory(history);
        this.colorChooser.setRecentColors(recent);
        this.colorChooser.setActiveTab(activeTab);
        this.colorChooser.getSelectionModel().addChangeListener(this.listener);
        return this.colorChooser;
    }

    public void saveState() {
        if (this.colorChooser != null) {
            this.colorChooser.addColorToHistory(this.colorChooser.getColor());
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void setValue(Object value) {
        if (this.colorChooser != null) {
            this.colorChooser.setColor((Color)value);
        }
        if (!Objects.equals(value, this.getValue())) {
            super.setValue(value);
        }
    }
}

