/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.OverridePrototypeAction;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.DataTypeSymbol;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.DuplicateNameException;
import java.awt.Component;

public class EditPrototypeOverrideAction
extends AbstractDecompilerAction {
    public EditPrototypeOverrideAction() {
        super("Edit Signature Override");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionEditOverride"));
        this.setPopupMenuData(new MenuData(new String[]{"Edit Signature Override"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        Symbol sym = OverridePrototypeAction.getSymbol(function, context.getTokenAtCursor());
        if (sym == null) {
            return false;
        }
        return HighFunctionDBUtil.readOverride((Symbol)sym) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Function function = context.getFunction();
        Symbol sym = OverridePrototypeAction.getSymbol(function, context.getTokenAtCursor());
        if (sym == null) {
            return;
        }
        DataTypeSymbol dts = HighFunctionDBUtil.readOverride((Symbol)sym);
        if (dts == null) {
            return;
        }
        Function func = context.getFunction();
        Program program = func.getProgram();
        PcodeOp op = OverridePrototypeAction.getCallOp(program, context.getTokenAtCursor());
        Function calledFunc = null;
        if (op != null) {
            calledFunc = OverridePrototypeAction.getCalledFunction(program, op);
        }
        FunctionDefinition updatedFuncDef = null;
        try {
            FunctionDefinition funcDef = (FunctionDefinition)dts.getDataType().copy((DataTypeManager)program.getDataTypeManager());
            funcDef.setName(calledFunc != null ? calledFunc.getName() : "func");
            updatedFuncDef = OverridePrototypeAction.editSignature(context, calledFunc, funcDef.getPrototypeString());
            if (updatedFuncDef == null) {
                return;
            }
        }
        catch (InvalidNameException | DuplicateNameException e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected error", (Throwable)e);
        }
        int transaction = program.startTransaction("Override Signature");
        try {
            Address addr = sym.getAddress();
            sym.delete();
            HighFunctionDBUtil.writeOverride((Function)func, (Address)addr, (FunctionSignature)updatedFuncDef);
            dts.cleanupUnusedOverride();
        }
        catch (Exception e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)context.getDecompilerPanel(), (String)"Override Signature Failed", (Object)("Error overriding signature: " + String.valueOf(e)));
        }
        finally {
            program.endTransaction(transaction, true);
        }
    }
}

