/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emulate;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.error.LowlevelError;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class EmulateInstructionStateModifier {
    protected final Emulate emu;
    protected final Language language;
    private Map<Integer, OpBehaviorOther> pcodeOpMap;

    protected EmulateInstructionStateModifier(Emulate emu) {
        this.emu = emu;
        this.language = emu.getLanguage();
    }

    protected final void registerPcodeOpBehavior(String opName, OpBehaviorOther pcodeOpBehavior) {
        if (this.pcodeOpMap == null) {
            this.pcodeOpMap = new HashMap<Integer, OpBehaviorOther>();
        }
        int numUserOps = this.language.getNumberOfUserDefinedOpNames();
        for (int i = 0; i < numUserOps; ++i) {
            if (!opName.equals(this.language.getUserDefinedOpName(i))) continue;
            this.pcodeOpMap.put(i, pcodeOpBehavior);
            return;
        }
        throw new LowlevelError("Undefined pcodeop name: " + opName);
    }

    public final boolean executeCallOther(PcodeOp op) throws LowlevelError {
        if (this.pcodeOpMap == null) {
            return false;
        }
        Varnode[] inputs = op.getInputs();
        OpBehaviorOther opBehaviorOther = this.pcodeOpMap.get((int)inputs[0].getOffset());
        if (opBehaviorOther == null) {
            return false;
        }
        opBehaviorOther.evaluate(this.emu, op.getOutput(), inputs);
        return true;
    }

    public void initialExecuteCallback(Emulate emulate, Address current_address, RegisterValue contextRegisterValue) throws LowlevelError {
    }

    public void postExecuteCallback(Emulate emulate, Address lastExecuteAddress, PcodeOp[] lastExecutePcode, int lastPcodeIndex, Address currentAddress) throws LowlevelError {
    }

    public Map<Integer, OpBehaviorOther> getPcodeOpMap() {
        if (this.pcodeOpMap == null) {
            return Map.of();
        }
        return Collections.unmodifiableMap(this.pcodeOpMap);
    }
}

