/* AMD Zen3 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2021 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 64
#define GMP_LIMB_BYTES 8

/* Disable use of slow functions.  FIXME: We should disable lib inclusion.  */
#undef HAVE_NATIVE_mpn_mul_2
#undef HAVE_NATIVE_mpn_addmul_2

/* 3800-4700 MHz Vermeer */
/* FFT tuning limit = 10,000,000 */
/* Generated by tuneup.c, 2021-01-01, gcc 9.3 */

#define MOD_1_NORM_THRESHOLD                64
#define MOD_1_UNNORM_THRESHOLD              85
#define MOD_1N_TO_MOD_1_1_THRESHOLD          5
#define MOD_1U_TO_MOD_1_1_THRESHOLD          6
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        11
#define MOD_1_2_TO_MOD_1_4_THRESHOLD        35
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD      9
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1_NORM_THRESHOLD              9
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD              15
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           18

#define DIV_1_VS_MUL_1_PERCENT             398

#define MUL_TOOM22_THRESHOLD                20
#define MUL_TOOM33_THRESHOLD                89
#define MUL_TOOM44_THRESHOLD               130
#define MUL_TOOM6H_THRESHOLD               303
#define MUL_TOOM8H_THRESHOLD               418

#define MUL_TOOM32_TO_TOOM43_THRESHOLD      89
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     107
#define MUL_TOOM42_TO_TOOM53_THRESHOLD      87
#define MUL_TOOM42_TO_TOOM63_THRESHOLD      94
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     130

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 32
#define SQR_TOOM3_THRESHOLD                109
#define SQR_TOOM4_THRESHOLD                336
#define SQR_TOOM6_THRESHOLD                414
#define SQR_TOOM8_THRESHOLD                592

#define MULMID_TOOM42_THRESHOLD             38

#define MULMOD_BNM1_THRESHOLD               14
#define SQRMOD_BNM1_THRESHOLD               17

#define MUL_FFT_MODF_THRESHOLD             332  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    332, 5}, {     19, 6}, {     10, 5}, {     21, 6}, \
    {     21, 7}, {     11, 6}, {     23, 7}, {     12, 6}, \
    {     25, 7}, {     21, 8}, {     11, 7}, {     25, 8}, \
    {     13, 7}, {     27, 8}, {     15, 7}, {     31, 8}, \
    {     17, 7}, {     35, 8}, {     21, 9}, {     11, 8}, \
    {     27, 9}, {     15, 8}, {     35, 9}, {     19, 8}, \
    {     39, 9}, {     23, 8}, {     47, 9}, {     27,10}, \
    {     15, 9}, {     31, 8}, {     63, 9}, {     35, 8}, \
    {     73, 9}, {     39,10}, {     23, 9}, {     51,11}, \
    {     15,10}, {     31, 9}, {     71,10}, {     39, 9}, \
    {     79,10}, {     55,11}, {     31,10}, {     79,11}, \
    {     47,10}, {     95,12}, {     31,11}, {     63,10}, \
    {    127, 9}, {    255,10}, {    135,11}, {     79,10}, \
    {    159, 9}, {    319, 8}, {    639,10}, {    175, 9}, \
    {    351,11}, {     95,10}, {    191, 9}, {    383,10}, \
    {    207,11}, {    111,10}, {    223,12}, {     63,11}, \
    {    127,10}, {    255, 9}, {    511,10}, {    271, 9}, \
    {    543,11}, {    143,10}, {    287, 9}, {    575,10}, \
    {    303, 9}, {    607,11}, {    159,10}, {    319, 9}, \
    {    639,11}, {    175,10}, {    351,12}, {     95,11}, \
    {    191,10}, {    383,11}, {    207,10}, {    415,11}, \
    {    223,13}, {     63,12}, {    127,11}, {    255,10}, \
    {    511,11}, {    271,10}, {    543,11}, {    287,10}, \
    {    575,11}, {    303,10}, {    607,12}, {    159,11}, \
    {    319,10}, {    639,11}, {    351,10}, {    703,12}, \
    {    191,11}, {    415,12}, {    223,11}, {    479,13}, \
    {    127,12}, {    255,11}, {    543,10}, {   1087,12}, \
    {    287,11}, {    575,10}, {   1151,11}, {    607,12}, \
    {    319,11}, {    639,12}, {    351,11}, {    703,13}, \
    {    191,12}, {    383,11}, {    767,12}, {    415,11}, \
    {    831,10}, {   1663,12}, {    447,11}, {    895,12}, \
    {    479,14}, {    127,13}, {    255,12}, {    511,11}, \
    {   1023,12}, {    543,11}, {   1087,12}, {    575,11}, \
    {   1151,12}, {    607,13}, {    319,12}, {    639,11}, \
    {   1279,12}, {    671,11}, {   1343,10}, {   2687,12}, \
    {    703,13}, {    383,12}, {    767,11}, {   1535,12}, \
    {    831,11}, {   1663,13}, {    447,12}, {    895,11}, \
    {   1791,12}, {    959,11}, {   1919,10}, {   3839,14}, \
    {    255,13}, {    511,12}, {   1087,13}, {    575,12}, \
    {   1151,11}, {   2303,12}, {   1215,11}, {   2431,13}, \
    {    639,12}, {   1279, 8}, {  24063,10}, {   6399,11}, \
    {   3327,13}, {    895,12}, {   1791,13}, {    959,12}, \
    {   1919,11}, {   3839,15}, {    255,14}, {    511,13}, \
    {   1087,12}, {   2175,13}, {   1215,12}, {   2431,14}, \
    {  16384,15}, {  32768,16}, {  65536,17}, { 131072,18}, \
    { 262144,19}, { 524288,20}, {1048576,21}, {2097152,22}, \
    {4194304,23}, {8388608,24} }
#define MUL_FFT_TABLE3_SIZE 186
#define MUL_FFT_THRESHOLD                 3264

#define SQR_FFT_MODF_THRESHOLD             340  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    340, 5}, {     19, 6}, {     10, 5}, {     21, 6}, \
    {     11, 5}, {     23, 6}, {     25, 7}, {     13, 6}, \
    {     27, 7}, {     25, 8}, {     13, 7}, {     28, 8}, \
    {     15, 7}, {     31, 8}, {     21, 9}, {     11, 8}, \
    {     27, 9}, {     15, 8}, {     33, 9}, {     19, 8}, \
    {     43, 9}, {     23, 8}, {     47, 9}, {     27,10}, \
    {     15, 9}, {     31, 8}, {     63, 9}, {     43,10}, \
    {     23, 9}, {     47,11}, {     15,10}, {     31, 9}, \
    {     67,10}, {     39, 9}, {     83,10}, {     47, 9}, \
    {     95,10}, {     55,11}, {     31,10}, {     79,11}, \
    {     47,10}, {     95,12}, {     31,11}, {     63,10}, \
    {    127, 9}, {    255,10}, {    135,11}, {     79,10}, \
    {    159, 9}, {    319,11}, {     95,10}, {    191, 9}, \
    {    383,12}, {     63,11}, {    127,10}, {    255, 9}, \
    {    511,10}, {    271,11}, {    143,10}, {    287, 9}, \
    {    575,10}, {    303, 9}, {    607,11}, {    159,10}, \
    {    319, 9}, {    639,12}, {     95,11}, {    191,10}, \
    {    383,13}, {     63,12}, {    127,11}, {    255,10}, \
    {    511,11}, {    271,10}, {    543,11}, {    287,10}, \
    {    575,11}, {    303,10}, {    607,12}, {    159,11}, \
    {    319,10}, {    639,11}, {    335,10}, {    671,11}, \
    {    351,10}, {    703,12}, {    191,11}, {    383,10}, \
    {    767,11}, {    415,12}, {    223,11}, {    447,13}, \
    {    127,12}, {    255,11}, {    543,12}, {    287,11}, \
    {    607,12}, {    319,11}, {    671,12}, {    351,11}, \
    {    703,13}, {    191,12}, {    383,11}, {    767,12}, \
    {    415,11}, {    831,12}, {    479,14}, {    127,13}, \
    {    255,12}, {    511,11}, {   1023,12}, {    607,11}, \
    {   1215,13}, {    319,12}, {    671,11}, {   1343,12}, \
    {    735,13}, {    383,12}, {    799,11}, {   1599,10}, \
    {   3199,12}, {    831,13}, {    447,12}, {    895,11}, \
    {   1791,12}, {    959,11}, {   1919,13}, {    511,12}, \
    {   1087,13}, {    575,12}, {   1215,13}, {    639,12}, \
    {   1343,13}, {    703,12}, {   1407,14}, {    383,13}, \
    {    767,12}, {   1599,13}, {    831,12}, {   1663,13}, \
    {    895,12}, {   1791,13}, {    959,12}, {   1919,15}, \
    {    255,14}, {    511,13}, {   1023, 9}, {  17919,10}, \
    {   9727,12}, {   4096,13}, {   8192,14}, {  16384,15}, \
    {  32768,16}, {  65536,17}, { 131072,18}, { 262144,19}, \
    { 524288,20}, {1048576,21}, {2097152,22}, {4194304,23}, \
    {8388608,24} }
#define SQR_FFT_TABLE3_SIZE 161
#define SQR_FFT_THRESHOLD                 2624

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  31
#define MULLO_MUL_N_THRESHOLD             6440
#define SQRLO_BASECASE_THRESHOLD             9
#define SQRLO_DC_THRESHOLD                 129
#define SQRLO_SQR_THRESHOLD               5103

#define DC_DIV_QR_THRESHOLD                 19
#define DC_DIVAPPR_Q_THRESHOLD             123
#define DC_BDIV_QR_THRESHOLD                79
#define DC_BDIV_Q_THRESHOLD                154

#define INV_MULMOD_BNM1_THRESHOLD           42
#define INV_NEWTON_THRESHOLD               107
#define INV_APPR_THRESHOLD                 107

#define BINV_NEWTON_THRESHOLD              312
#define REDC_1_TO_REDC_N_THRESHOLD          77

#define MU_DIV_QR_THRESHOLD               1142
#define MU_DIVAPPR_Q_THRESHOLD            1258
#define MUPI_DIV_QR_THRESHOLD               30
#define MU_BDIV_QR_THRESHOLD              1120
#define MU_BDIV_Q_THRESHOLD               1394

#define POWM_SEC_TABLE  6,19,203,579,2245

#define GET_STR_DC_THRESHOLD                10
#define GET_STR_PRECOMPUTE_THRESHOLD        18
#define SET_STR_DC_THRESHOLD               115
#define SET_STR_PRECOMPUTE_THRESHOLD      1941

#define FAC_DSC_THRESHOLD                  182
#define FAC_ODD_THRESHOLD                   44

#define MATRIX22_STRASSEN_THRESHOLD         15
#define HGCD2_DIV1_METHOD                    1  /* 13.04% faster than 3 */
#define HGCD_THRESHOLD                      65
#define HGCD_APPR_THRESHOLD                 50
#define HGCD_REDUCE_THRESHOLD             2121
#define GCD_DC_THRESHOLD                   293
#define GCDEXT_DC_THRESHOLD                186
#define JACOBI_BASE_METHOD                   1  /* 12.79% faster than 3 */
