/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.task;

import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.jsampler.MidiDeviceModel;
import org.jsampler.MidiInstrument;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.SamplerModel;
import org.jsampler.task.EnhancedTask;
import org.linuxsampler.lscp.BoolParameter;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiInputDriver;
import org.linuxsampler.lscp.MidiInstrumentEntry;
import org.linuxsampler.lscp.MidiInstrumentInfo;
import org.linuxsampler.lscp.MidiInstrumentMapInfo;
import org.linuxsampler.lscp.Parameter;

public class Midi {
    private Midi() {
    }

    public static class UpdateInstruments
    extends EnhancedTask {
        private int mapId;

        public UpdateInstruments(int n) {
            this.setTitle("Midi.UpdateInstruments_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.UpdateInstruments.desc"));
            this.mapId = n;
        }

        @Override
        public void exec() throws Exception {
            SamplerModel samplerModel = CC.getSamplerModel();
            int[][] nArray = CC.getClient().getMidiInstrumentEntries(this.mapId);
            MidiInstrumentMap midiInstrumentMap = samplerModel.getMidiInstrumentMapById(this.mapId);
            boolean bl = false;
            for (Object object : midiInstrumentMap.getAllMidiInstruments()) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == null || !this.equal((MidiInstrument)object, nArray[i])) continue;
                    nArray[i] = null;
                    bl = true;
                }
                if (!bl) {
                    midiInstrumentMap.unmapMidiInstrument(((MidiInstrument)object).getInfo().getEntry());
                }
                bl = false;
            }
            int[][] nArray2 = nArray;
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                object = nArray2[i];
                if (object == null) continue;
                MidiInstrumentInfo midiInstrumentInfo = CC.getClient().getMidiInstrumentInfo((int)object[0], (int)object[1], (int)object[2]);
                MidiInstrument midiInstrument = new MidiInstrument(midiInstrumentInfo);
                midiInstrumentMap.mapMidiInstrument(midiInstrumentInfo.getEntry(), midiInstrument);
            }
        }

        private boolean equal(MidiInstrument midiInstrument, int[] nArray) {
            return midiInstrument.getInfo().getMapId() == nArray[0] && midiInstrument.getInfo().getMidiBank() == nArray[1] && midiInstrument.getInfo().getMidiProgram() == nArray[2];
        }

        public int getMapId() {
            return this.mapId;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof UpdateInstruments)) {
                return false;
            }
            return ((UpdateInstruments)object).getMapId() == this.getMapId();
        }
    }

    public static class UpdateInstrumentInfo
    extends EnhancedTask {
        private int mapId;
        private int bank;
        private int program;

        public UpdateInstrumentInfo(int n, int n2, int n3) {
            this.setTitle("Midi.UpdateInstrumentInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.UpdateInstrumentInfo.desc"));
            this.mapId = n;
            this.bank = n2;
            this.program = n3;
        }

        @Override
        public void exec() throws Exception {
            MidiInstrumentInfo midiInstrumentInfo = CC.getClient().getMidiInstrumentInfo(this.mapId, this.bank, this.program);
            MidiInstrumentMap midiInstrumentMap = CC.getSamplerModel().getMidiInstrumentMapById(this.mapId);
            midiInstrumentMap.getMidiInstrument(this.bank, this.program).setInfo(midiInstrumentInfo);
        }
    }

    public static class UnmapInstrument
    extends EnhancedTask {
        private int mapId;
        private int bank;
        private int program;

        public UnmapInstrument(int n, int n2, int n3) {
            this.setTitle("Midi.UnmapInstrument_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.UnmapInstrument.desc"));
            this.mapId = n;
            this.bank = n2;
            this.program = n3;
        }

        @Override
        public void exec() throws Exception {
            MidiInstrumentEntry midiInstrumentEntry = new MidiInstrumentEntry(this.bank, this.program);
            CC.getClient().unmapMidiInstrument(this.mapId, midiInstrumentEntry);
        }
    }

    public static class MapInstrument
    extends EnhancedTask {
        private int mapId;
        private int bank;
        private int program;
        private MidiInstrumentInfo instrInfo;

        public MapInstrument(int n, int n2, int n3, MidiInstrumentInfo midiInstrumentInfo) {
            this.setTitle("Midi.MapInstrument_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.MapInstrument.desc"));
            this.mapId = n;
            this.bank = n2;
            this.program = n3;
            this.instrInfo = midiInstrumentInfo;
        }

        @Override
        public void exec() throws Exception {
            MidiInstrumentEntry midiInstrumentEntry = new MidiInstrumentEntry(this.bank, this.program);
            CC.getClient().mapMidiInstrument(this.mapId, midiInstrumentEntry, this.instrInfo, true);
        }
    }

    public static class UpdateInstrumentMaps
    extends EnhancedTask {
        public UpdateInstrumentMaps() {
            this.setTitle("Midi.UpdateInstrumentMaps_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.UpdateInstrumentMaps.desc"));
        }

        @Override
        public void exec() throws Exception {
            int n;
            SamplerModel samplerModel = CC.getSamplerModel();
            Integer[] integerArray = CC.getClient().getMidiInstrumentMapIDs();
            boolean bl = false;
            for (MidiInstrumentMap midiInstrumentMap : samplerModel.getMidiInstrumentMaps()) {
                for (n = 0; n < integerArray.length; ++n) {
                    if (integerArray[n].intValue() != midiInstrumentMap.getMapId()) continue;
                    integerArray[n] = -1;
                    bl = true;
                }
                if (!bl) {
                    samplerModel.removeMidiInstrumentMapById(midiInstrumentMap.getMapId());
                }
                bl = false;
            }
            Integer[] integerArray2 = integerArray;
            int n2 = integerArray2.length;
            for (int i = 0; i < n2; ++i) {
                n = integerArray2[i];
                if (n < 0) continue;
                MidiInstrumentMapInfo midiInstrumentMapInfo = CC.getClient().getMidiInstrumentMapInfo(n);
                samplerModel.addMidiInstrumentMap(new MidiInstrumentMap(midiInstrumentMapInfo));
            }
        }
    }

    public static class GetInstrumentMaps
    extends EnhancedTask<MidiInstrumentMap[]> {
        public GetInstrumentMaps() {
            this.setTitle("Midi.GetInstrumentMaps_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.GetInstrumentMaps.desc"));
        }

        @Override
        public void exec() throws Exception {
            MidiInstrumentMapInfo[] midiInstrumentMapInfoArray = CC.getClient().getMidiInstrumentMaps();
            MidiInstrumentMap[] midiInstrumentMapArray = new MidiInstrumentMap[midiInstrumentMapInfoArray.length];
            for (int i = 0; i < midiInstrumentMapInfoArray.length; ++i) {
                midiInstrumentMapArray[i] = this.createMap(midiInstrumentMapInfoArray[i]);
            }
            this.setResult(midiInstrumentMapArray);
        }

        private MidiInstrumentMap createMap(MidiInstrumentMapInfo midiInstrumentMapInfo) throws Exception {
            MidiInstrumentInfo[] midiInstrumentInfoArray;
            MidiInstrumentMap midiInstrumentMap = new MidiInstrumentMap(midiInstrumentMapInfo);
            for (MidiInstrumentInfo midiInstrumentInfo : midiInstrumentInfoArray = CC.getClient().getMidiInstruments(midiInstrumentMapInfo.getMapId())) {
                MidiInstrument midiInstrument = new MidiInstrument(midiInstrumentInfo);
                midiInstrumentMap.mapMidiInstrument(midiInstrumentInfo.getEntry(), midiInstrument);
            }
            return midiInstrumentMap;
        }
    }

    public static class UpdateInstrumentMapInfo
    extends EnhancedTask {
        private int mapId;

        public UpdateInstrumentMapInfo(int n) {
            this.setTitle("Midi.UpdateInstrumentMapInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.UpdateInstrumentMapInfo.desc", n));
            this.mapId = n;
        }

        @Override
        public void exec() throws Exception {
            MidiInstrumentMapInfo midiInstrumentMapInfo = CC.getClient().getMidiInstrumentMapInfo(this.mapId);
            CC.getSamplerModel().getMidiInstrumentMapById(this.mapId).setInfo(midiInstrumentMapInfo);
        }
    }

    public static class SetInstrumentMapInfo
    extends EnhancedTask {
        private int mapId;
        private String name;

        public SetInstrumentMapInfo(int n, String string) {
            this.setTitle("Midi.SetInstrumentMapInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.SetInstrumentMapInfo.desc"));
            this.mapId = n;
            this.name = string;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setMidiInstrumentMapName(this.mapId, this.name);
        }
    }

    public static class RemoveInstrumentMap
    extends EnhancedTask {
        private int mapId;

        public RemoveInstrumentMap(int n) {
            this.setTitle("Midi.RemoveMidiInstrumentMap_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.RemoveMidiInstrumentMap.desc", n));
            this.mapId = n;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().removeMidiInstrumentMap(this.mapId);
        }
    }

    public static class AddInstrumentMap
    extends EnhancedTask<Integer> {
        private String name;

        public AddInstrumentMap(String string) {
            this.setTitle("Midi.AddMidiInstrumentMap_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.AddMidiInstrumentMap.desc"));
            this.name = string;
        }

        @Override
        public void exec() throws Exception {
            Integer n = CC.getClient().addMidiInstrumentMap(this.name);
            this.setResult(n);
        }
    }

    public static class UpdateDevices
    extends EnhancedTask {
        public UpdateDevices() {
            this.setTitle("Midi.UpdateDevices_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.UpdateDevices.desc"));
        }

        @Override
        public void exec() throws Exception {
            int n;
            SamplerModel samplerModel = CC.getSamplerModel();
            Integer[] integerArray = CC.getClient().getMidiInputDeviceIDs();
            boolean bl = false;
            for (MidiDeviceModel midiDeviceModel : samplerModel.getMidiDevices()) {
                for (n = 0; n < integerArray.length; ++n) {
                    if (midiDeviceModel.getDeviceId() != integerArray[n].intValue()) continue;
                    integerArray[n] = -1;
                    bl = true;
                }
                if (!bl) {
                    samplerModel.removeMidiDeviceById(midiDeviceModel.getDeviceId());
                }
                bl = false;
            }
            Integer[] integerArray2 = integerArray;
            int n2 = integerArray2.length;
            for (int i = 0; i < n2; ++i) {
                n = integerArray2[i];
                if (n < 0) continue;
                MidiInputDevice midiInputDevice = CC.getClient().getMidiInputDeviceInfo(n);
                samplerModel.addMidiDevice(midiInputDevice);
            }
        }
    }

    public static class UpdateDeviceInfo
    extends EnhancedTask {
        private int dev;

        public UpdateDeviceInfo(int n) {
            this.setTitle("Midi.UpdateDeviceInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.UpdateDeviceInfo.desc", n));
            this.dev = n;
        }

        @Override
        public void exec() throws Exception {
            MidiInputDevice midiInputDevice = CC.getClient().getMidiInputDeviceInfo(this.dev);
            CC.getSamplerModel().getMidiDeviceById(this.dev).setDeviceInfo(midiInputDevice);
        }
    }

    public static class SetPortParameter
    extends EnhancedTask {
        private int dev;
        private int port;
        private Parameter prm;

        public SetPortParameter(int n, int n2, Parameter parameter) {
            this.setTitle("Midi.SetPortParameter_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.SetPortParameter.desc"));
            this.dev = n;
            this.port = n2;
            this.prm = parameter;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setMidiInputPortParameter(this.dev, this.port, this.prm);
        }
    }

    public static class SetPortCount
    extends EnhancedTask {
        private int deviceId;
        private int ports;

        public SetPortCount(int n, int n2) {
            this.setTitle("SetMidiInputPortCount_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.SetPortCount.desc", n));
            this.deviceId = n;
            this.ports = n2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setMidiInputPortCount(this.deviceId, this.ports);
        }
    }

    public static class SetDeviceParameter
    extends EnhancedTask {
        private int dev;
        private Parameter prm;

        public SetDeviceParameter(int n, String string, boolean bl) {
            this(n, new BoolParameter(string, bl));
        }

        public SetDeviceParameter(int n, Parameter parameter) {
            this.setTitle("Midi.SetDeviceParameter_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.SetDeviceParameter.desc"));
            this.dev = n;
            this.prm = parameter;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setMidiInputDeviceParameter(this.dev, this.prm);
            CC.getSamplerModel().getMidiDeviceById(this.dev);
        }
    }

    public static class EnableDevice
    extends EnhancedTask {
        private int dev;
        private boolean enable;

        public EnableDevice(int n, boolean bl) {
            this.setTitle("Midi.EnableDevice_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.EnableDevice.desc", n));
            this.dev = n;
            this.enable = bl;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().enableMidiInputDevice(this.dev, this.enable);
            CC.getSamplerModel().getMidiDeviceById(this.dev).setActive(this.enable);
        }
    }

    public static class DestroyDevice
    extends EnhancedTask {
        private int deviceId;

        public DestroyDevice(int n) {
            this.setTitle("Midi.DestroyDevice_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.DestroyDevice.desc", n));
            this.deviceId = n;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().destroyMidiInputDevice(this.deviceId);
        }
    }

    public static class CreateDevice
    extends EnhancedTask<Integer> {
        private String driver;
        private Parameter[] parameters;

        public CreateDevice(String string, Parameter ... parameterArray) {
            this.setTitle("Midi.CreateDevice_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.CreateDevice.desc"));
            this.driver = string;
            this.parameters = parameterArray;
        }

        @Override
        public void exec() throws Exception {
            this.run0();
        }

        private void run0() throws Exception {
            Integer n = CC.getClient().createMidiInputDevice(this.driver, this.parameters);
            this.setResult(n);
        }
    }

    public static class GetDriverParametersInfo
    extends EnhancedTask<Parameter[]> {
        private String driver;
        Parameter[] depList;

        public GetDriverParametersInfo(String string, Parameter ... parameterArray) {
            this.setTitle("Midi.GetDriverParametersInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.GetDriverParametersInfo.desc"));
            this.driver = string;
            this.depList = parameterArray;
        }

        @Override
        public void exec() throws Exception {
            MidiInputDriver midiInputDriver = CC.getClient().getMidiInputDriverInfo(this.driver, this.depList);
            this.setResult(midiInputDriver.getParameters());
        }
    }

    public static class GetDrivers
    extends EnhancedTask<MidiInputDriver[]> {
        public GetDrivers() {
            this.setTitle("Midi.GetDrivers_task");
            this.setDescription(JSI18n.i18n.getMessage("Midi.GetDrivers.desc"));
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getMidiInputDrivers());
        }
    }
}

