/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.returntypes;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.inputtypes.Point;
import com.amazon.randomcutforest.parkservices.config.CorrectionMode;
import com.amazon.randomcutforest.parkservices.config.ScoringStrategy;
import com.amazon.randomcutforest.returntypes.DiVector;
import java.util.Arrays;
import lombok.Generated;

public class RCFComputeDescriptor
extends Point {
    ForestMode forestMode = ForestMode.STANDARD;
    TransformMethod transformMethod = TransformMethod.NONE;
    ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
    ScoringStrategy scoringStrategy = ScoringStrategy.EXPECTED_INVERSE_DEPTH;
    CorrectionMode correctionMode = CorrectionMode.NONE;
    int shingleSize;
    int dimension;
    int inputLength;
    long totalUpdates;
    boolean reasonableForecast;
    long internalTimeStamp;
    int numberOfTrees;
    int[] missingValues;
    int numberOfNewImputes;
    float[] RCFPoint;
    double RCFScore;
    double anomalyGrade;
    double threshold;
    DiVector attribution;
    int relativeIndex;
    double[] deviations;
    double[] postDeviations;
    double[] scale;
    double[] shift;
    double[] postShift;
    double transformDecay;
    float[] expectedRCFPoint;
    long lastAnomalyInternalTimestamp;
    float[] lastExpectedRCFPoint;
    long expectedTimeStamp;
    double[][] imputedPoints;

    public RCFComputeDescriptor(double[] input, long inputTimeStamp) {
        super(input, inputTimeStamp);
    }

    public RCFComputeDescriptor(double[] input, long inputTimeStamp, ForestMode forestMode, TransformMethod transformMethod, ImputationMethod imputationMethod) {
        super(input, inputTimeStamp);
        this.forestMode = forestMode;
        this.transformMethod = transformMethod;
        this.imputationMethod = imputationMethod;
    }

    public void setShift(double[] shift) {
        this.shift = this.copyIfNotnull(shift);
    }

    public void setPostShift(double[] shift) {
        this.postShift = this.copyIfNotnull(shift);
    }

    public double[] getShift() {
        return this.copyIfNotnull(this.shift);
    }

    public void setScale(double[] scale) {
        this.scale = this.copyIfNotnull(scale);
    }

    public double[] getScale() {
        return this.copyIfNotnull(this.scale);
    }

    public double[] getDeltaShift() {
        if (this.shift == null || this.postShift == null) {
            return null;
        }
        double[] answer = new double[this.shift.length];
        for (int i = 0; i < this.shift.length; ++i) {
            answer[i] = this.postShift[i] - this.shift[i];
        }
        return answer;
    }

    public void setExpectedRCFPoint(float[] point) {
        this.expectedRCFPoint = this.copyIfNotnull(point);
    }

    public float[] getExpectedRCFPoint() {
        return this.copyIfNotnull(this.expectedRCFPoint);
    }

    public void setRCFPoint(float[] point) {
        this.RCFPoint = this.copyIfNotnull(point);
    }

    public float[] getRCFPoint() {
        return this.copyIfNotnull(this.RCFPoint);
    }

    public void setLastExpectedRCFdPoint(float[] point) {
        this.lastExpectedRCFPoint = this.copyIfNotnull(point);
    }

    public float[] getLastExpectedRCFPoint() {
        return this.copyIfNotnull(this.lastExpectedRCFPoint);
    }

    public void setAttribution(DiVector attribution) {
        this.attribution = attribution == null ? null : new DiVector(attribution);
    }

    public DiVector getAttribution() {
        return this.attribution == null ? null : new DiVector(this.attribution);
    }

    public int[] getMissingValues() {
        return this.missingValues == null ? null : Arrays.copyOf(this.missingValues, this.missingValues.length);
    }

    public void setMissingValues(int[] values) {
        this.missingValues = values == null ? null : Arrays.copyOf(values, values.length);
    }

    protected float[] copyIfNotnull(float[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    public void setImputedPoint(int index, double[] impute) {
        CommonUtils.checkArgument((this.numberOfNewImputes > 0 ? 1 : 0) != 0, (String)" no imputation is indicated");
        CommonUtils.checkArgument((impute != null && impute.length == this.inputLength ? 1 : 0) != 0, (String)"incorrect length");
        if (this.imputedPoints == null) {
            this.imputedPoints = new double[Math.min(this.numberOfNewImputes, this.shingleSize - 1)][];
        }
        CommonUtils.checkArgument((this.imputedPoints.length > index && index >= 0 && this.imputedPoints[index] == null ? 1 : 0) != 0, (String)"already set!");
        this.imputedPoints[index] = Arrays.copyOf(impute, this.inputLength);
    }

    public RCFComputeDescriptor copyOf() {
        RCFComputeDescriptor answer = new RCFComputeDescriptor(this.getCurrentInput(), this.getInputTimestamp(), this.forestMode, this.transformMethod, this.imputationMethod);
        answer.setShingleSize(this.shingleSize);
        answer.setDimension(this.dimension);
        answer.setInputLength(this.inputLength);
        answer.setReasonableForecast(this.reasonableForecast);
        answer.setAttribution(this.attribution);
        answer.setRCFPoint(this.RCFPoint);
        answer.setRCFScore(this.RCFScore);
        answer.setInternalTimeStamp(this.internalTimeStamp);
        answer.setExpectedRCFPoint(this.expectedRCFPoint);
        answer.setNumberOfTrees(this.numberOfTrees);
        answer.setTotalUpdates(this.totalUpdates);
        answer.setNumberOfNewImputes(this.numberOfNewImputes);
        answer.setLastAnomalyInternalTimestamp(this.lastAnomalyInternalTimestamp);
        answer.setLastExpectedRCFdPoint(this.lastExpectedRCFPoint);
        answer.setScoringStrategy(this.scoringStrategy);
        answer.setShift(this.shift);
        answer.setScale(this.scale);
        answer.setPostShift(this.postShift);
        answer.setTransformDecay(this.transformDecay);
        answer.setAnomalyGrade(this.anomalyGrade);
        answer.setThreshold(this.threshold);
        answer.setCorrectionMode(this.correctionMode);
        return answer;
    }

    @Generated
    public ForestMode getForestMode() {
        return this.forestMode;
    }

    @Generated
    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    @Generated
    public ImputationMethod getImputationMethod() {
        return this.imputationMethod;
    }

    @Generated
    public ScoringStrategy getScoringStrategy() {
        return this.scoringStrategy;
    }

    @Generated
    public CorrectionMode getCorrectionMode() {
        return this.correctionMode;
    }

    @Generated
    public int getShingleSize() {
        return this.shingleSize;
    }

    @Generated
    public int getDimension() {
        return this.dimension;
    }

    @Generated
    public int getInputLength() {
        return this.inputLength;
    }

    @Generated
    public long getTotalUpdates() {
        return this.totalUpdates;
    }

    @Generated
    public boolean isReasonableForecast() {
        return this.reasonableForecast;
    }

    @Generated
    public long getInternalTimeStamp() {
        return this.internalTimeStamp;
    }

    @Generated
    public int getNumberOfTrees() {
        return this.numberOfTrees;
    }

    @Generated
    public int getNumberOfNewImputes() {
        return this.numberOfNewImputes;
    }

    @Generated
    public double getRCFScore() {
        return this.RCFScore;
    }

    @Generated
    public double getAnomalyGrade() {
        return this.anomalyGrade;
    }

    @Generated
    public double getThreshold() {
        return this.threshold;
    }

    @Generated
    public int getRelativeIndex() {
        return this.relativeIndex;
    }

    @Generated
    public double[] getDeviations() {
        return this.deviations;
    }

    @Generated
    public double[] getPostDeviations() {
        return this.postDeviations;
    }

    @Generated
    public double[] getPostShift() {
        return this.postShift;
    }

    @Generated
    public double getTransformDecay() {
        return this.transformDecay;
    }

    @Generated
    public long getLastAnomalyInternalTimestamp() {
        return this.lastAnomalyInternalTimestamp;
    }

    @Generated
    public long getExpectedTimeStamp() {
        return this.expectedTimeStamp;
    }

    @Generated
    public double[][] getImputedPoints() {
        return this.imputedPoints;
    }

    @Generated
    public void setForestMode(ForestMode forestMode) {
        this.forestMode = forestMode;
    }

    @Generated
    public void setTransformMethod(TransformMethod transformMethod) {
        this.transformMethod = transformMethod;
    }

    @Generated
    public void setImputationMethod(ImputationMethod imputationMethod) {
        this.imputationMethod = imputationMethod;
    }

    @Generated
    public void setScoringStrategy(ScoringStrategy scoringStrategy) {
        this.scoringStrategy = scoringStrategy;
    }

    @Generated
    public void setCorrectionMode(CorrectionMode correctionMode) {
        this.correctionMode = correctionMode;
    }

    @Generated
    public void setShingleSize(int shingleSize) {
        this.shingleSize = shingleSize;
    }

    @Generated
    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Generated
    public void setInputLength(int inputLength) {
        this.inputLength = inputLength;
    }

    @Generated
    public void setTotalUpdates(long totalUpdates) {
        this.totalUpdates = totalUpdates;
    }

    @Generated
    public void setReasonableForecast(boolean reasonableForecast) {
        this.reasonableForecast = reasonableForecast;
    }

    @Generated
    public void setInternalTimeStamp(long internalTimeStamp) {
        this.internalTimeStamp = internalTimeStamp;
    }

    @Generated
    public void setNumberOfTrees(int numberOfTrees) {
        this.numberOfTrees = numberOfTrees;
    }

    @Generated
    public void setNumberOfNewImputes(int numberOfNewImputes) {
        this.numberOfNewImputes = numberOfNewImputes;
    }

    @Generated
    public void setRCFScore(double RCFScore) {
        this.RCFScore = RCFScore;
    }

    @Generated
    public void setAnomalyGrade(double anomalyGrade) {
        this.anomalyGrade = anomalyGrade;
    }

    @Generated
    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Generated
    public void setRelativeIndex(int relativeIndex) {
        this.relativeIndex = relativeIndex;
    }

    @Generated
    public void setDeviations(double[] deviations) {
        this.deviations = deviations;
    }

    @Generated
    public void setPostDeviations(double[] postDeviations) {
        this.postDeviations = postDeviations;
    }

    @Generated
    public void setTransformDecay(double transformDecay) {
        this.transformDecay = transformDecay;
    }

    @Generated
    public void setLastAnomalyInternalTimestamp(long lastAnomalyInternalTimestamp) {
        this.lastAnomalyInternalTimestamp = lastAnomalyInternalTimestamp;
    }

    @Generated
    public void setLastExpectedRCFPoint(float[] lastExpectedRCFPoint) {
        this.lastExpectedRCFPoint = lastExpectedRCFPoint;
    }

    @Generated
    public void setExpectedTimeStamp(long expectedTimeStamp) {
        this.expectedTimeStamp = expectedTimeStamp;
    }

    @Generated
    public void setImputedPoints(double[][] imputedPoints) {
        this.imputedPoints = imputedPoints;
    }
}

