/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import tim.prune.I18nManager;
import tim.prune.gui.colour.ColourPatch;

public class ColourChooser {
    private final JDialog _dialog;
    private final JColorChooser _chooser = new JColorChooser();
    private ColourPatch _patch = null;

    public ColourChooser(JDialog jDialog) {
        this._chooser.setPreviewPanel(new JPanel());
        ColourChooser.setPanels(this._chooser);
        this._dialog = JColorChooser.createDialog(jDialog, I18nManager.getText("dialog.colourchooser.title"), true, this._chooser, actionEvent -> this.chosenColour(), actionEvent -> {
            ColourPatch colourPatch = this._patch = null;
        });
    }

    private static void setPanels(JColorChooser jColorChooser) {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray;
        AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = abstractColorChooserPanelArray = jColorChooser.getChooserPanels();
        int n = abstractColorChooserPanelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractColorChooserPanel abstractColorChooserPanel = abstractColorChooserPanelArray2[n2];
            if (ColourChooser.shouldPanelBeRemoved(abstractColorChooserPanel)) {
                jColorChooser.removeChooserPanel(abstractColorChooserPanel);
            }
            ++n2;
        }
    }

    private static boolean shouldPanelBeRemoved(AbstractColorChooserPanel abstractColorChooserPanel) {
        return abstractColorChooserPanel.getClass().getName().toLowerCase().contains("defaultswatch") || abstractColorChooserPanel.getDisplayName().toUpperCase().contains("CMYK");
    }

    public void showDialog(ColourPatch colourPatch) {
        this._patch = colourPatch;
        this._chooser.setColor(colourPatch.getBackground());
        this._dialog.setLocationRelativeTo(this._dialog.getParent());
        this._dialog.setVisible(true);
    }

    private void chosenColour() {
        if (this._patch != null) {
            this._patch.setColour(this._chooser.getColor());
        }
        this._patch = null;
    }
}

