/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Scales image pixel intensities to make the sum of all pixels equal a
user-defined constant.


The default value of the constant is 1. It can be changed with SetConstant() .

This transform is especially useful for normalizing a convolution
kernel.

This code was contributed in the Insight Journal paper: "FFT based
convolution" by Lehmann G. https://doi.org/10.54294/0iky0u


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 NormalizeImageFilter

 StatisticsImageFilter

 DivideImageFilter

 itk::simple::NormalizeToConstant for the procedural interface

 itk::NormalizeToConstantImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkNormalizeToConstantImageFilter.h
*/
public class NormalizeToConstantImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected NormalizeToConstantImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.NormalizeToConstantImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NormalizeToConstantImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(NormalizeToConstantImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::NormalizeToConstantImageFilter::~NormalizeToConstantImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_NormalizeToConstantImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::NormalizeToConstantImageFilter::NormalizeToConstantImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  NormalizeToConstantImageFilter() {
    this(SimpleITKJNI.new_NormalizeToConstantImageFilter(), true);
  }

  /**
Self&amp; itk::simple::NormalizeToConstantImageFilter::SetConstant(double Constant)

Set/get the normalization constant.

*/
public  void setConstant(double Constant) {
    SimpleITKJNI.NormalizeToConstantImageFilter_setConstant(swigCPtr, this, Constant);
  }

  /**
double itk::simple::NormalizeToConstantImageFilter::GetConstant() const

Set/get the normalization constant.

*/
public  double getConstant() {
    return SimpleITKJNI.NormalizeToConstantImageFilter_getConstant(swigCPtr, this);
  }

  /**
std::string itk::simple::NormalizeToConstantImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.NormalizeToConstantImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::NormalizeToConstantImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.NormalizeToConstantImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::NormalizeToConstantImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.NormalizeToConstantImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
