/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurityManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public final class JDK13Services {
    private static final String PROPERTIES_FILENAME = "sound.properties";
    private static Properties properties;

    private JDK13Services() {
    }

    public static List<?> getProviders(Class<?> clazz) {
        List<?> list = !MixerProvider.class.equals(clazz) && !FormatConversionProvider.class.equals(clazz) && !AudioFileReader.class.equals(clazz) && !AudioFileWriter.class.equals(clazz) && !MidiDeviceProvider.class.equals(clazz) && !SoundbankReader.class.equals(clazz) && !MidiFileWriter.class.equals(clazz) && !MidiFileReader.class.equals(clazz) ? new ArrayList(0) : JSSecurityManager.getProviders(clazz);
        return Collections.unmodifiableList(list);
    }

    public static synchronized String getDefaultProviderClassName(Class clazz) {
        int n;
        String string = null;
        String string2 = JDK13Services.getDefaultProvider(clazz);
        if (string2 != null && (n = string2.indexOf(35)) != 0) {
            string = n > 0 ? string2.substring(0, n) : string2;
        }
        return string;
    }

    public static synchronized String getDefaultInstanceName(Class clazz) {
        int n;
        String string = null;
        String string2 = JDK13Services.getDefaultProvider(clazz);
        if (string2 != null && (n = string2.indexOf(35)) >= 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1);
        }
        return string;
    }

    private static synchronized String getDefaultProvider(Class clazz) {
        if (!(SourceDataLine.class.equals((Object)clazz) || TargetDataLine.class.equals((Object)clazz) || Clip.class.equals((Object)clazz) || Port.class.equals((Object)clazz) || Receiver.class.equals((Object)clazz) || Transmitter.class.equals((Object)clazz) || Synthesizer.class.equals((Object)clazz) || Sequencer.class.equals((Object)clazz))) {
            return null;
        }
        String string = clazz.getName();
        String string2 = AccessController.doPrivileged(() -> System.getProperty(string));
        if (string2 == null) {
            string2 = JDK13Services.getProperties().getProperty(string);
        }
        if ("".equals(string2)) {
            string2 = null;
        }
        return string2;
    }

    private static synchronized Properties getProperties() {
        if (properties == null) {
            properties = new Properties();
            JSSecurityManager.loadProperties(properties, PROPERTIES_FILENAME);
        }
        return properties;
    }
}

