/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.man;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.man.FileParser;

public class TerminalPage {
    private List<String> lines;
    private FileParser fileParser;

    public TerminalPage(FileParser fileParser, int columns) throws IOException {
        this.fileParser = fileParser;
        this.lines = fileParser.loadPage(columns);
    }

    public String getLine(int num) {
        if (num < this.lines.size()) {
            return this.lines.get(num);
        }
        return "";
    }

    public List<Integer> findWord(String word) {
        ArrayList<Integer> wordLines = new ArrayList<Integer>();
        for (int i = 0; i < this.lines.size(); ++i) {
            if (!this.lines.get(i).contains(word)) continue;
            wordLines.add(i);
        }
        return wordLines;
    }

    public int size() {
        return this.lines.size();
    }

    public String getFileName() {
        return this.fileParser.getName();
    }

    public List<String> getLines() {
        return this.lines;
    }

    public boolean hasData() {
        return !this.lines.isEmpty();
    }

    public void clear() {
        this.lines.clear();
    }

    public static enum Search {
        SEARCHING,
        RESULT,
        NOT_FOUND,
        NO_SEARCH;

    }
}

