/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.internal;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.resource.jdbc.internal.ResourceRegistryStandardImpl;
import org.hibernate.resource.jdbc.internal.ResultSetsSet;

final class ResultsetsTrackingContainer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(ResourceRegistryStandardImpl.class);
    private static final ResultSetsSet EMPTY = new ResultSetsSet();
    private Statement key_1;
    private ResultSetsSet value_1;
    private HashMap<Statement, ResultSetsSet> xref;

    ResultsetsTrackingContainer() {
    }

    public boolean hasRegisteredResources() {
        return this.key_1 != null;
    }

    public void registerExpectingNew(Statement statement) {
        assert (this.statementNotExisting(statement)) : "JDBC Statement already registered";
        if (this.key_1 == null) {
            this.key_1 = statement;
            this.value_1 = EMPTY;
        } else {
            this.getXrefForWriting().put(statement, EMPTY);
        }
    }

    private boolean statementNotExisting(Statement statement) {
        if (this.key_1 == statement) {
            return false;
        }
        if (this.xref != null) {
            return !this.xref.containsKey(statement);
        }
        return true;
    }

    private HashMap<Statement, ResultSetsSet> getXrefForWriting() {
        if (this.xref == null) {
            this.xref = new HashMap();
        }
        return this.xref;
    }

    private void trickleDown() {
        Iterator<Map.Entry<Statement, ResultSetsSet>> iterator;
        if (this.xref != null && (iterator = this.xref.entrySet().iterator()).hasNext()) {
            Map.Entry<Statement, ResultSetsSet> entry = iterator.next();
            this.key_1 = entry.getKey();
            this.value_1 = entry.getValue();
            iterator.remove();
        }
    }

    public void storeAssociatedResultset(Statement statement, ResultSet resultSet) {
        if (this.key_1 == null) {
            this.key_1 = statement;
            this.value_1 = new ResultSetsSet();
            assert (this.warnOnNotNull(null));
            this.value_1.storeResultSet(resultSet);
        } else if (this.key_1 == statement) {
            this.value_1 = this.ensureWriteable(this.value_1);
            this.value_1.storeResultSet(resultSet);
        } else {
            ResultSetsSet resultSetsSet = null;
            if (this.xref == null) {
                this.xref = new HashMap();
            } else {
                resultSetsSet = this.xref.get(statement);
            }
            assert (this.warnOnNotNull(resultSetsSet));
            if (resultSetsSet == null || resultSetsSet == EMPTY) {
                resultSetsSet = new ResultSetsSet();
                this.xref.put(statement, resultSetsSet);
            }
            resultSetsSet.storeResultSet(resultSet);
        }
    }

    private ResultSetsSet ensureWriteable(ResultSetsSet value) {
        if (value == null || value == EMPTY) {
            return new ResultSetsSet();
        }
        return value;
    }

    public ResultSetsSet getForResultSetRemoval(Statement statement) {
        ResultSetsSet existingEntry = this.key_1 == statement ? this.value_1 : (this.key_1 != null && this.xref != null ? this.xref.get(statement) : null);
        assert (this.warnOnNotNull(existingEntry));
        return existingEntry;
    }

    public ResultSetsSet remove(Statement statement) {
        if (this.key_1 == statement) {
            ResultSetsSet v = this.value_1;
            this.key_1 = null;
            this.value_1 = null;
            this.trickleDown();
            return v;
        }
        if (this.xref != null) {
            return this.xref.remove(statement);
        }
        return null;
    }

    private boolean warnOnNotNull(ResultSetsSet existingEntry) {
        if (existingEntry == null) {
            log.trace("ResultSet statement was not registered (on register)");
        }
        return true;
    }

    public void forEach(BiConsumer<Statement, ResultSetsSet> action) {
        if (this.key_1 != null) {
            action.accept(this.key_1, this.value_1);
            if (this.xref != null) {
                this.xref.forEach(action);
            }
        }
    }

    public void clear() {
        this.key_1 = null;
        this.value_1 = null;
        if (this.xref != null) {
            this.xref.clear();
            this.xref = null;
        }
    }
}

