/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.internal.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.GcmSpecUtil;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ASN1AlgorithmParameters
extends BaseAlgorithmParameters {
    private final String algorithm;
    private ASN1Primitive spec;

    ASN1AlgorithmParameters(String string) {
        this.algorithm = string;
    }

    @Override
    protected byte[] localGetEncoded() throws IOException {
        return this.spec.getEncoded();
    }

    @Override
    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == IvParameterSpec.class) {
            if (this.spec instanceof ASN1OctetString) {
                return new IvParameterSpec(ASN1OctetString.getInstance(this.spec).getOctets());
            }
            if (this.spec instanceof ASN1Sequence) {
                return new IvParameterSpec(GCMParameters.getInstance(this.spec).getNonce());
            }
            throw new InvalidParameterSpecException("Cannot convert AlgorithmParameters to IvParameterSpec");
        }
        if (clazz == AlgorithmParameterSpec.class) {
            if (this.spec instanceof ASN1OctetString) {
                return new IvParameterSpec(ASN1OctetString.getInstance(this.spec).getOctets());
            }
            if (this.spec instanceof ASN1Sequence) {
                if (GcmSpecUtil.gcmSpecExists()) {
                    return GcmSpecUtil.extractGcmSpec(this.spec);
                }
                GCMParameters gCMParameters = GCMParameters.getInstance(this.spec);
                return new AEADParameterSpec(gCMParameters.getNonce(), gCMParameters.getIcvLen() * 8);
            }
            throw new InvalidParameterSpecException("Cannot convert AlgorithmParameters to IvParameterSpec");
        }
        if (GcmSpecUtil.isGcmSpec(clazz)) {
            return GcmSpecUtil.extractGcmSpec(this.spec);
        }
        if (clazz == AEADParameterSpec.class && this.spec instanceof ASN1Sequence) {
            try {
                GCMParameters gCMParameters = GCMParameters.getInstance(this.spec);
                return new AEADParameterSpec(gCMParameters.getNonce(), gCMParameters.getIcvLen() * 8);
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException("ASN.1 encoding not recognized: " + exception.getMessage());
            }
        }
        throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.spec = algorithmParameterSpec instanceof AEADParameterSpec ? new GCMParameters(((AEADParameterSpec)algorithmParameterSpec).getNonce(), (((AEADParameterSpec)algorithmParameterSpec).getMacSizeInBits() + 7) / 8).toASN1Primitive() : new DEROctetString(((IvParameterSpec)algorithmParameterSpec).getIV());
        } else if (GcmSpecUtil.isGcmSpec(algorithmParameterSpec)) {
            this.spec = GcmSpecUtil.extractGcmParameters(algorithmParameterSpec).toASN1Primitive();
        } else {
            throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
        }
    }

    @Override
    protected void localInit(byte[] byArray) throws IOException {
        this.spec = ASN1Primitive.fromByteArray(byArray);
    }

    @Override
    protected String engineToString() {
        return "ASN.1 Parameters";
    }
}

