\name{MinimumImageFilter}
\alias{MinimumImageFilter}
\title{MinimumImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements a pixel-wise operator Min(a,b) between two images.
MinimumImageFilter}
\details{
The pixel values of the output image are the minimum between the
corresponding pixels of the two input images.
This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.
See:
Minimum for the procedural interface
itk::MinimumImageFilter for the Doxygen on the original ITK class.
MinimumImageFilter}
%C++ includes: sitkMinimumImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, double constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(double constant, const Image &image2):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, double constant):}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{ MinimumImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MinimumImageFilter():}{
Destructor
}
}
}
