/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;

public class EnvironmentVariableCredentialsProvider
implements AWSCredentialsProvider {
    private static final String PROVIDER_NAME = "EnvironmentVariableCredentialsProvider";

    @Override
    public AWSCredentials getCredentials() {
        String secretKey;
        String accessKey = System.getenv("AWS_ACCESS_KEY_ID");
        if (accessKey == null) {
            accessKey = System.getenv("AWS_ACCESS_KEY");
        }
        if ((secretKey = System.getenv("AWS_SECRET_KEY")) == null) {
            secretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        }
        String accountId = System.getenv("AWS_ACCOUNT_ID");
        accessKey = StringUtils.trim(accessKey);
        secretKey = StringUtils.trim(secretKey);
        accountId = StringUtils.trim(accountId);
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new SdkClientException("Unable to load AWS credentials from environment variables (AWS_ACCESS_KEY_ID (or AWS_ACCESS_KEY) and AWS_SECRET_KEY (or AWS_SECRET_ACCESS_KEY))");
        }
        String sessionToken = StringUtils.trim(System.getenv("AWS_SESSION_TOKEN"));
        return StringUtils.isNullOrEmpty(sessionToken) ? new BasicAWSCredentials(accessKey, secretKey, accountId, PROVIDER_NAME) : new BasicSessionCredentials(accessKey, secretKey, sessionToken, accountId, PROVIDER_NAME);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

