/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.validators;

import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.AccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.claims.AccessTokenHash;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.validators.InvalidHashException;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AccessTokenValidator {
    public static void validate(AccessToken accessToken, JWSAlgorithm jwsAlgorithm, AccessTokenHash accessTokenHash) throws InvalidHashException {
        AccessTokenHash expectedHash = AccessTokenHash.compute(accessToken, jwsAlgorithm);
        if (expectedHash == null) {
            throw InvalidHashException.INVALID_ACCESS_T0KEN_HASH_EXCEPTION;
        }
        if (!expectedHash.equals(accessTokenHash)) {
            throw InvalidHashException.INVALID_ACCESS_T0KEN_HASH_EXCEPTION;
        }
    }
}

