/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.tsp.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.BEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERIA5String;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.ContentInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.Evidence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.TimeStampAndCRL;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.TimeStampTokenEvidence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.TimeStampedData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.tsp.TimeStampToken;
import net.snowflake.client.jdbc.internal.org.bouncycastle.tsp.cms.CMSTimeStampedData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.tsp.cms.CMSTimeStampedGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.io.Streams;

public class CMSTimeStampedDataGenerator
extends CMSTimeStampedGenerator {
    public CMSTimeStampedData generate(TimeStampToken timeStampToken) throws CMSException {
        return this.generate(timeStampToken, (InputStream)null);
    }

    public CMSTimeStampedData generate(TimeStampToken timeStampToken, byte[] byArray) throws CMSException {
        return this.generate(timeStampToken, new ByteArrayInputStream(byArray));
    }

    public CMSTimeStampedData generate(TimeStampToken timeStampToken, InputStream inputStream) throws CMSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (inputStream != null) {
            try {
                Streams.pipeAll(inputStream, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new CMSException("exception encapsulating content: " + iOException.getMessage(), iOException);
            }
        }
        BEROctetString bEROctetString = null;
        if (byteArrayOutputStream.size() != 0) {
            bEROctetString = new BEROctetString(byteArrayOutputStream.toByteArray());
        }
        TimeStampAndCRL timeStampAndCRL = new TimeStampAndCRL(timeStampToken.toCMSSignedData().toASN1Structure());
        DERIA5String dERIA5String = null;
        if (this.dataUri != null) {
            dERIA5String = new DERIA5String(this.dataUri.toString());
        }
        return new CMSTimeStampedData(new ContentInfo(CMSObjectIdentifiers.timestampedData, new TimeStampedData(dERIA5String, this.metaData, bEROctetString, new Evidence(new TimeStampTokenEvidence(timeStampAndCRL)))));
    }
}

