/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.js.builtins.ArrayIteratorGetLengthNode;
import com.oracle.truffle.js.builtins.ArrayIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayIterator;
import com.oracle.truffle.js.runtime.builtins.JSArrayIteratorObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ArrayIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ArrayIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ArrayIteratorPrototypeBuiltins();

    protected ArrayIteratorPrototypeBuiltins() {
        super(JSArrayIterator.PROTOTYPE_NAME, ArrayIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ArrayIteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return ArrayIteratorPrototypeBuiltinsFactory.ArrayIteratorNextNodeGen.create(context, builtin, ArrayIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ArrayIteratorPrototype implements BuiltinEnum<ArrayIteratorPrototype>
    {
        next(0);

        private final int length;

        private ArrayIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class ArrayIteratorNextNode
    extends JSBuiltinNode {
        protected ArrayIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isUndefined(array)"})
        JSObject doArrayIterator(JSArrayIteratorObject iterator, @Bind(value="iterator.getIteratedObject()") Object array, @Cached.Shared @Cached(value="create(getContext())") CreateIterResultObjectNode createIterResultObjectNode, @Cached(value="create(getContext())") ReadElementNode readElementNode, @Cached ArrayIteratorGetLengthNode getLengthNode, @Cached(inline=true) LongToIntOrDoubleNode toJSIndex, @Cached InlinedIntValueProfile iterationKindProfile) {
            Object result;
            long index = iterator.getNextIndex();
            int itemKind = iterationKindProfile.profile((Node)this, iterator.getIterationKind());
            long length = getLengthNode.execute(this, array, this.getJSContext());
            if (index >= length) {
                iterator.setIteratedObject((Object)Undefined.instance);
                return createIterResultObjectNode.execute((Object)Undefined.instance, true);
            }
            iterator.setNextIndex(index + 1L);
            Number indexNumber = null;
            if ((itemKind & 1) != 0) {
                indexNumber = toJSIndex.execute(this, index);
            }
            if (itemKind == 1) {
                result = indexNumber;
            } else {
                Object elementValue = readElementNode.executeWithTargetAndIndex(array, index);
                if (itemKind == 2) {
                    result = elementValue;
                } else {
                    assert (itemKind == 3 && indexNumber != null);
                    result = JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), new Object[]{indexNumber, elementValue});
                }
            }
            return createIterResultObjectNode.execute(result, false);
        }

        @Specialization(guards={"isUndefined(iterator.getIteratedObject())"})
        static JSObject doArrayIteratorDetached(JSArrayIteratorObject iterator, @Cached(value="create(getContext())") @Cached.Shared CreateIterResultObjectNode createIterResultObjectNode) {
            return createIterResultObjectNode.execute((Object)Undefined.instance, true);
        }

        @Fallback
        static JSObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeError("not an Array Iterator");
        }
    }
}

