/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSCompareNode;
import com.oracle.truffle.js.nodes.binary.JSGreaterThanNodeGen;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringOrNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Strings;
import java.util.Set;

@NodeInfo(shortName=">")
public abstract class JSGreaterThanNode
extends JSCompareNode {
    protected JSGreaterThanNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JSGreaterThanNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSGreaterThanNodeGen.create(left, right);
    }

    public static JSGreaterThanNode create() {
        return JSGreaterThanNodeGen.create(null, null);
    }

    public abstract boolean executeBoolean(Object var1, Object var2);

    @Specialization
    protected static boolean doInt(int a, int b) {
        return a > b;
    }

    @Specialization
    protected static boolean doSafeInteger(int a, SafeInteger b) {
        return (long)a > b.longValue();
    }

    @Specialization
    protected static boolean doSafeInteger(SafeInteger a, int b) {
        return a.longValue() > (long)b;
    }

    @Specialization
    protected static boolean doSafeInteger(SafeInteger a, SafeInteger b) {
        return a.longValue() > b.longValue();
    }

    @Specialization
    protected static boolean doLong(long a, long b) {
        return a > b;
    }

    @Specialization
    protected static boolean doDouble(double a, double b) {
        return a > b;
    }

    @Specialization
    protected static boolean doString(TruffleString a, TruffleString b, @Cached TruffleString.CompareCharsUTF16Node compareNode) {
        return Strings.compareTo(compareNode, a, b) > 0;
    }

    @Specialization
    protected static boolean doStringDouble(TruffleString a, double b, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSGreaterThanNode.doDouble(stringToDouble.execute(a), b);
    }

    @Specialization
    protected static boolean doDoubleString(double a, TruffleString b, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSGreaterThanNode.doDouble(a, stringToDouble.execute(b));
    }

    @Specialization
    protected static boolean doStringBigInt(TruffleString a, BigInt b) {
        BigInt aBigInt = JSRuntime.stringToBigInt(a);
        return aBigInt == null ? false : JSGreaterThanNode.doBigInt(aBigInt, b);
    }

    @Specialization
    protected static boolean doBigIntString(BigInt a, TruffleString b) {
        BigInt bBigInt = JSRuntime.stringToBigInt(b);
        return bBigInt == null ? false : JSGreaterThanNode.doBigInt(a, bBigInt);
    }

    @Specialization
    protected static boolean doBigInt(BigInt a, BigInt b) {
        return a.compareTo(b) > 0;
    }

    @Specialization
    protected static boolean doBigIntAndInt(BigInt a, int b) {
        return a.compareValueTo(b) > 0;
    }

    @Specialization
    protected static boolean doBigIntAndNumber(BigInt a, double b) {
        if (Double.isNaN(b)) {
            return false;
        }
        return a.compareValueTo(b) > 0;
    }

    @Specialization
    protected static boolean doIntAndBigInt(int a, BigInt b) {
        return b.compareValueTo(a) < 0;
    }

    @Specialization
    protected static boolean doNumberAndBigInt(double a, BigInt b) {
        if (Double.isNaN(a)) {
            return false;
        }
        return b.compareValueTo(a) < 0;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected static boolean doOverloaded(Object a, Object b, @Bind Node node, @Cached(value="createHintNumberRightToLeft(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode, @Cached(inline=true) JSToBooleanNode toBooleanNode) {
        return toBooleanNode.executeBoolean(node, overloadedOperatorNode.execute(b, a));
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_OPEN;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doString", "doStringDouble", "doDoubleString", "doStringBigInt", "doBigIntString", "doBigInt", "doBigIntAndInt", "doIntAndBigInt", "doBigIntAndNumber", "doNumberAndBigInt"})
    protected static boolean doGeneric(Object a, Object b, @Cached JSToStringOrNumberNode toStringOrNumber1, @Cached JSToPrimitiveNode toPrimitive1, @Cached JSToStringOrNumberNode toStringOrNumber2, @Cached JSToPrimitiveNode toPrimitive2, @Cached JSGreaterThanNode greaterThanNode) {
        Object aPrimitive = toPrimitive1.executeHintNumber(a);
        Object bPrimitive = toPrimitive2.executeHintNumber(b);
        aPrimitive = toStringOrNumber1.execute(aPrimitive);
        bPrimitive = toStringOrNumber2.execute(bPrimitive);
        return greaterThanNode.executeBoolean(aPrimitive, bPrimitive);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSGreaterThanNodeGen.create(JSGreaterThanNode.cloneUninitialized(this.getLeft(), materializedTags), JSGreaterThanNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

