/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Optional;
import java.util.regex.Pattern;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.GrepOptions;
import schemacrawler.schemacrawler.OptionsBuilder;

public final class GrepOptionsBuilder
implements OptionsBuilder<GrepOptionsBuilder, GrepOptions> {
    private Optional<InclusionRule> grepTableInclusionRule = Optional.empty();
    private Optional<InclusionRule> grepColumnInclusionRule = Optional.empty();
    private Optional<InclusionRule> grepDefinitionInclusionRule;
    private boolean grepInvertMatch;
    private Optional<InclusionRule> grepRoutineParameterInclusionRule = Optional.empty();

    public static GrepOptionsBuilder builder() {
        return new GrepOptionsBuilder();
    }

    public static GrepOptions newGrepOptions() {
        return GrepOptionsBuilder.builder().toOptions();
    }

    private GrepOptionsBuilder() {
        this.grepDefinitionInclusionRule = Optional.empty();
    }

    public GrepOptionsBuilder fromOptions(GrepOptions options) {
        if (options == null) {
            return this;
        }
        this.grepTableInclusionRule = Optional.ofNullable(options.grepTableInclusionRule());
        this.grepColumnInclusionRule = Optional.ofNullable(options.grepColumnInclusionRule());
        this.grepRoutineParameterInclusionRule = Optional.ofNullable(options.grepRoutineParameterInclusionRule());
        this.grepDefinitionInclusionRule = Optional.ofNullable(options.grepDefinitionInclusionRule());
        this.grepInvertMatch = options.isGrepInvertMatch();
        return this;
    }

    public GrepOptionsBuilder includeGreppedColumns(InclusionRule grepColumnInclusionRule) {
        this.grepColumnInclusionRule = Optional.ofNullable(grepColumnInclusionRule);
        return this;
    }

    public GrepOptionsBuilder includeGreppedColumns(Pattern grepColumnPattern) {
        this.grepColumnInclusionRule = grepColumnPattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepColumnPattern));
        return this;
    }

    public GrepOptionsBuilder includeGreppedDefinitions(InclusionRule grepDefinitionInclusionRule) {
        this.grepDefinitionInclusionRule = Optional.ofNullable(grepDefinitionInclusionRule);
        return this;
    }

    public GrepOptionsBuilder includeGreppedDefinitions(Pattern grepDefinitionPattern) {
        this.grepDefinitionInclusionRule = grepDefinitionPattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepDefinitionPattern));
        return this;
    }

    public GrepOptionsBuilder includeGreppedRoutineParameters(InclusionRule grepRoutineParameterInclusionRule) {
        this.grepRoutineParameterInclusionRule = Optional.ofNullable(grepRoutineParameterInclusionRule);
        return this;
    }

    public GrepOptionsBuilder includeGreppedRoutineParameters(Pattern grepRoutineParametersPattern) {
        this.grepRoutineParameterInclusionRule = grepRoutineParametersPattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepRoutineParametersPattern));
        return this;
    }

    public GrepOptionsBuilder includeGreppedTables(InclusionRule grepTableInclusionRule) {
        this.grepTableInclusionRule = Optional.ofNullable(grepTableInclusionRule);
        return this;
    }

    public GrepOptionsBuilder includeGreppedTables(Pattern grepTablePattern) {
        this.grepTableInclusionRule = grepTablePattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepTablePattern));
        return this;
    }

    public GrepOptionsBuilder invertGrepMatch(boolean grepInvertMatch) {
        this.grepInvertMatch = grepInvertMatch;
        return this;
    }

    @Override
    public GrepOptions toOptions() {
        GrepOptions grepOptions = new GrepOptions(this.grepTableInclusionRule.orElse(null), this.grepColumnInclusionRule.orElse(null), this.grepRoutineParameterInclusionRule.orElse(null), this.grepDefinitionInclusionRule.orElse(null), this.grepInvertMatch);
        return grepOptions;
    }
}

