SELECT
  NULL AS ROUTINE_CATALOG,
  DEPS.OWNER AS ROUTINE_SCHEMA,
  DEPS.NAME AS ROUTINE_NAME,
  DEPS.NAME AS SPECIFIC_NAME,
  NULL AS REFERENCED_OBJECT_CATALOG,
  DEPS.REFERENCED_OWNER AS REFERENCED_OBJECT_SCHEMA,
  DEPS.REFERENCED_NAME AS REFERENCED_OBJECT_NAME,
  DEPS.REFERENCED_NAME AS REFERENCED_OBJECT_SPECIFIC_NAME,
  OBJECTS.OBJECT_TYPE AS REFERENCED_OBJECT_TYPE
FROM
  ${catalogscope}_DEPENDENCIES DEPS
  INNER JOIN ${catalogscope}_OBJECTS OBJECTS
    ON DEPS.REFERENCED_OWNER = OBJECTS.OWNER
   AND DEPS.REFERENCED_NAME = OBJECTS.OBJECT_NAME
   AND DEPS.REFERENCED_TYPE != 'PACKAGE' 
  INNER JOIN ${catalogscope}_USERS USERS
    ON DEPS.OWNER = USERS.USERNAME
   AND USERS.ORACLE_MAINTAINED = 'N'
   AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
   AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
   AND NOT REGEXP_LIKE(USERS.USERNAME, '^OPS\$ORACLE$')
WHERE
  DEPS.TYPE IN ('PROCEDURE', 'FUNCTION')
  AND REGEXP_LIKE(DEPS.OWNER, '${schema-inclusion-rule}')
ORDER BY
  ROUTINE_SCHEMA,
  ROUTINE_NAME,
  REFERENCED_OBJECT_NAME
