# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_signstar_request_signature_global_optspecs
	string join \n v/verbose q/quiet h/help
end

function __fish_signstar_request_signature_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_signstar_request_signature_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_signstar_request_signature_using_subcommand
	set -l cmd (__fish_signstar_request_signature_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c signstar-request-signature -n "__fish_signstar_request_signature_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_needs_command" -s h -l help -d 'Print help'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_needs_command" -f -a "prepare" -d 'Prepare signing request for a file'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_needs_command" -f -a "send" -d 'Send signing request over SSH'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand prepare" -s v -l verbose -d 'Increase logging verbosity'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand prepare" -s q -l quiet -d 'Decrease logging verbosity'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand prepare" -s h -l help -d 'Print help'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand send" -l host -d 'Signstar host' -r
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand send" -l port -d 'Signstar port' -r
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand send" -l user -d 'Signstar user' -r
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand send" -l agent-socket -d 'Path to the agent socket used for user authentication' -r -F
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand send" -l user-public-key -d 'Public key of a user' -r
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand send" -l known-hosts -d 'Path of a known hosts file which contains public keys of the serevr' -r -F
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand send" -s v -l verbose -d 'Increase logging verbosity'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand send" -s q -l quiet -d 'Decrease logging verbosity'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand send" -s h -l help -d 'Print help'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand help; and not __fish_seen_subcommand_from prepare send help" -f -a "prepare" -d 'Prepare signing request for a file'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand help; and not __fish_seen_subcommand_from prepare send help" -f -a "send" -d 'Send signing request over SSH'
complete -c signstar-request-signature -n "__fish_signstar_request_signature_using_subcommand help; and not __fish_seen_subcommand_from prepare send help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
