/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELManager;
import javax.el.ExpressionFactory;
import javax.el.ImportHandler;
import javax.el.JreCompat;
import javax.el.Util;
import javax.el.ValueExpression;

public class ELProcessor {
    private static final Set<String> PRIMITIVES = new HashSet<String>();
    private static final String[] EMPTY_STRING_ARRAY;
    private final ELManager manager = new ELManager();
    private final ELContext context = this.manager.getELContext();
    private final ExpressionFactory factory = ELManager.getExpressionFactory();

    public ELManager getELManager() {
        return this.manager;
    }

    public Object eval(String string) {
        return this.getValue(string, Object.class);
    }

    public Object getValue(String string, Class<?> clazz) {
        ValueExpression valueExpression = this.factory.createValueExpression(this.context, ELProcessor.bracket(string), clazz);
        return valueExpression.getValue(this.context);
    }

    public void setValue(String string, Object object) {
        ValueExpression valueExpression = this.factory.createValueExpression(this.context, ELProcessor.bracket(string), Object.class);
        valueExpression.setValue(this.context, object);
    }

    public void setVariable(String string, String string2) {
        if (string2 == null) {
            this.manager.setVariable(string, null);
        } else {
            ValueExpression valueExpression = this.factory.createValueExpression(this.context, ELProcessor.bracket(string2), Object.class);
            this.manager.setVariable(string, valueExpression);
        }
    }

    public void defineFunction(String string, String string2, String string3, String string4) throws ClassNotFoundException, NoSuchMethodException {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new NullPointerException(Util.message(this.context, "elProcessor.defineFunctionNullParams", new Object[0]));
        }
        Class<?> clazz = this.context.getImportHandler().resolveClass(string3);
        if (clazz == null) {
            clazz = Class.forName(string3, true, Util.getContextClassLoader());
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new ClassNotFoundException(Util.message(this.context, "elProcessor.defineFunctionInvalidClass", string3));
        }
        MethodSignature methodSignature = new MethodSignature(this.context, string4, string3);
        if (string2.length() == 0) {
            string2 = methodSignature.getName();
        }
        Method[] methodArray = clazz.getMethods();
        JreCompat jreCompat = JreCompat.getInstance();
        for (Method method : methodArray) {
            String[] stringArray;
            if (!Modifier.isStatic(method.getModifiers()) || !jreCompat.canAccess(null, method) || !method.getName().equals(methodSignature.getName())) continue;
            if (methodSignature.getParamTypeNames() == null) {
                this.manager.mapFunction(string, string2, method);
                return;
            }
            if (methodSignature.getParamTypeNames().length != method.getParameterTypes().length) continue;
            if (methodSignature.getParamTypeNames().length == 0) {
                this.manager.mapFunction(string, string2, method);
                return;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != (stringArray = methodSignature.getParamTypeNames()).length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                if (i == classArray.length - 1 && method.isVarArgs()) {
                    String string5 = stringArray[i];
                    if (string5.endsWith("...")) {
                        if ((string5 = string5.substring(0, string5.length() - 3)).equals(classArray[i].getName())) continue;
                        bl = false;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (classArray[i].getName().equals(stringArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.manager.mapFunction(string, string2, method);
            return;
        }
        throw new NoSuchMethodException(Util.message(this.context, "elProcessor.defineFunctionNoMethod", string4, string3));
    }

    public void defineFunction(String string, String string2, Method method) throws NoSuchMethodException {
        if (string == null || string2 == null || method == null) {
            throw new NullPointerException(Util.message(this.context, "elProcessor.defineFunctionNullParams", new Object[0]));
        }
        int n = method.getModifiers();
        JreCompat jreCompat = JreCompat.getInstance();
        if (!Modifier.isStatic(n) || !jreCompat.canAccess(null, method)) {
            throw new NoSuchMethodException(Util.message(this.context, "elProcessor.defineFunctionInvalidMethod", method.getName(), method.getDeclaringClass().getName()));
        }
        this.manager.mapFunction(string, string2, method);
    }

    public void defineBean(String string, Object object) {
        this.manager.defineBean(string, object);
    }

    private static String bracket(String string) {
        return "${" + string + "}";
    }

    static {
        PRIMITIVES.add("boolean");
        PRIMITIVES.add("byte");
        PRIMITIVES.add("char");
        PRIMITIVES.add("double");
        PRIMITIVES.add("float");
        PRIMITIVES.add("int");
        PRIMITIVES.add("long");
        PRIMITIVES.add("short");
        EMPTY_STRING_ARRAY = new String[0];
    }

    private static class MethodSignature {
        private final String name;
        private final String[] parameterTypeNames;

        MethodSignature(ELContext eLContext, String string, String string2) throws NoSuchMethodException {
            int n = string.indexOf(40);
            if (n == -1) {
                this.name = string.trim();
                this.parameterTypeNames = null;
            } else {
                String string3 = string.substring(0, n).trim();
                int n2 = -1;
                for (int i = 0; i < string3.length(); ++i) {
                    if (!Character.isWhitespace(string3.charAt(i))) continue;
                    n2 = i;
                    break;
                }
                if (n2 == -1) {
                    throw new NoSuchMethodException();
                }
                this.name = string3.substring(n2).trim();
                String string4 = string.substring(n).trim();
                if (!string4.endsWith(")")) {
                    throw new NoSuchMethodException(Util.message(eLContext, "elProcessor.defineFunctionInvalidParameterList", string4, string, string2));
                }
                if ((string4 = string4.substring(1, string4.length() - 1).trim()).length() == 0) {
                    this.parameterTypeNames = EMPTY_STRING_ARRAY;
                } else {
                    this.parameterTypeNames = string4.split(",");
                    ImportHandler importHandler = eLContext.getImportHandler();
                    for (int i = 0; i < this.parameterTypeNames.length; ++i) {
                        int n3;
                        Class<?> clazz;
                        boolean bl;
                        String string5 = this.parameterTypeNames[i].trim();
                        int n4 = 0;
                        int n5 = string5.indexOf(91);
                        if (n5 > -1) {
                            String string6 = string5.substring(0, n5).trim();
                            while (n5 > -1) {
                                ++n4;
                                n5 = string5.indexOf(91, n5 + 1);
                            }
                            string5 = string6;
                        }
                        boolean bl2 = false;
                        if (string5.endsWith("...")) {
                            bl2 = true;
                            n4 = 1;
                            string5 = string5.substring(0, string5.length() - 3).trim();
                        }
                        if ((bl = PRIMITIVES.contains(string5)) && n4 > 0) {
                            clazz = string5;
                            n3 = -1;
                            switch (((String)((Object)clazz)).hashCode()) {
                                case 64711720: {
                                    if (!((String)((Object)clazz)).equals("boolean")) break;
                                    n3 = 0;
                                    break;
                                }
                                case 3039496: {
                                    if (!((String)((Object)clazz)).equals("byte")) break;
                                    n3 = 1;
                                    break;
                                }
                                case 3052374: {
                                    if (!((String)((Object)clazz)).equals("char")) break;
                                    n3 = 2;
                                    break;
                                }
                                case -1325958191: {
                                    if (!((String)((Object)clazz)).equals("double")) break;
                                    n3 = 3;
                                    break;
                                }
                                case 97526364: {
                                    if (!((String)((Object)clazz)).equals("float")) break;
                                    n3 = 4;
                                    break;
                                }
                                case 104431: {
                                    if (!((String)((Object)clazz)).equals("int")) break;
                                    n3 = 5;
                                    break;
                                }
                                case 3327612: {
                                    if (!((String)((Object)clazz)).equals("long")) break;
                                    n3 = 6;
                                    break;
                                }
                                case 109413500: {
                                    if (!((String)((Object)clazz)).equals("short")) break;
                                    n3 = 7;
                                }
                            }
                            switch (n3) {
                                case 0: {
                                    string5 = "Z";
                                    break;
                                }
                                case 1: {
                                    string5 = "B";
                                    break;
                                }
                                case 2: {
                                    string5 = "C";
                                    break;
                                }
                                case 3: {
                                    string5 = "D";
                                    break;
                                }
                                case 4: {
                                    string5 = "F";
                                    break;
                                }
                                case 5: {
                                    string5 = "I";
                                    break;
                                }
                                case 6: {
                                    string5 = "J";
                                    break;
                                }
                                case 7: {
                                    string5 = "S";
                                    break;
                                }
                            }
                        } else if (!bl && !string5.contains(".")) {
                            clazz = importHandler.resolveClass(string5);
                            if (clazz == null) {
                                throw new NoSuchMethodException(Util.message(eLContext, "elProcessor.defineFunctionInvalidParameterTypeName", this.parameterTypeNames[i], string, string2));
                            }
                            string5 = clazz.getName();
                        }
                        if (n4 > 0) {
                            clazz = new StringBuilder();
                            for (n3 = 0; n3 < n4; ++n3) {
                                ((StringBuilder)((Object)clazz)).append('[');
                            }
                            if (!bl) {
                                ((StringBuilder)((Object)clazz)).append('L');
                            }
                            ((StringBuilder)((Object)clazz)).append(string5);
                            if (!bl) {
                                ((StringBuilder)((Object)clazz)).append(';');
                            }
                            string5 = ((StringBuilder)((Object)clazz)).toString();
                        }
                        if (bl2) {
                            string5 = string5 + "...";
                        }
                        this.parameterTypeNames[i] = string5;
                    }
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String[] getParamTypeNames() {
            return this.parameterTypeNames;
        }
    }
}

